/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.workflow.local.strategy.button;

import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.workflow.local.dto.ProcessTaskLogDto;
import com.biz.crm.workflow.local.strategy.button.AbstractLogButtonStrategy;
import com.biz.crm.workflow.sdk.constant.ProcessConstant;
import com.biz.crm.workflow.sdk.dto.TaskDto;
import com.biz.crm.workflow.sdk.enums.EffectiveScopeEnum;
import com.biz.crm.workflow.sdk.enums.ProcessOperateTypeEnum;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.bizunited.nebula.security.sdk.login.UserIdentity;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.flowable.engine.RuntimeService;
import org.flowable.engine.TaskService;
import org.flowable.task.api.Task;
import org.flowable.task.api.TaskQuery;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RejectProcessButtonStrategy
extends AbstractLogButtonStrategy {
    @Autowired
    private TaskService taskService;
    @Autowired
    private LoginUserService loginUserService;
    @Autowired
    private RuntimeService runtimeService;
    private static final String PROCESS_BUTTON_DESC = "\u9a73\u56de\u53d1\u8d77\u4eba";

    public String getProcessButtonCode() {
        return StringUtils.uncapitalize((String)this.getClass().getSimpleName());
    }

    public String getProcessButtonDesc() {
        return PROCESS_BUTTON_DESC;
    }

    public Integer getIndex() {
        return 2;
    }

    @Transactional
    public void handleTask(TaskDto dto) {
        Validate.notNull((Object)dto, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getTaskId(), (String)"\u4efb\u52a1\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getContent(), (String)"\u9a73\u56de\u7406\u7531\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(dto.getTaskId())).singleResult();
        Validate.notNull((Object)task, (String)"\u5f53\u524d\u4efb\u52a1\u4e0d\u5b58\u5728,\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        UserIdentity userIdentity = this.loginUserService.getLoginUser();
        Validate.notNull((Object)userIdentity, (String)"\u83b7\u53d6\u767b\u5f55\u4eba\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)userIdentity.getTenantCode(), (String)"\u83b7\u53d6\u767b\u5f55\u4eba\u79df\u6237\u4fe1\u606f\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)userIdentity.getAccount(), (String)"\u83b7\u53d6\u5f53\u524d\u767b\u5f55\u4eba\u4fe1\u606f\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        String accout = StringUtils.join((Object[])new String[]{userIdentity.getIdentityType(), ":", userIdentity.getAccount()});
        this.taskService.setVariable(task.getId(), ProcessConstant.PROCESS_INSTANCE_OPERATE_CODE, (Object)ProcessStatusEnum.REJECT.getDictCode());
        this.taskService.addComment(null, task.getProcessInstanceId(), String.format("%s\u9a73\u56de\u8be5\u5ba1\u6279\uff0c\u9a73\u56de\u7406\u7531\uff1a%s", accout, dto.getContent()));
        this.taskService.setAssignee(task.getId(), accout);
        this.runtimeService.deleteProcessInstance(task.getProcessInstanceId(), ProcessStatusEnum.REJECT.getDictCode());
        ProcessTaskLogDto processTaskLogDto = new ProcessTaskLogDto();
        processTaskLogDto.setTaskId(dto.getTaskId());
        processTaskLogDto.setProcessInstanceId(dto.getProcessInstanceId());
        processTaskLogDto.setOperateType(ProcessOperateTypeEnum.REJECTED.getDictCode());
        processTaskLogDto.setTaskDefinitionKey(task.getTaskDefinitionKey());
        processTaskLogDto.setOperateRemark(dto.getContent());
        this.addLog(processTaskLogDto);
    }

    public String getProcessButtonType() {
        return EffectiveScopeEnum.ALL.getDictCode();
    }
}

