/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.workflow.local.strategy.button;

import com.biz.crm.workflow.local.dto.ProcessTaskLogDto;
import com.biz.crm.workflow.local.service.ProcessTaskCommunicateService;
import com.biz.crm.workflow.local.strategy.button.AbstractLogButtonStrategy;
import com.biz.crm.workflow.sdk.dto.TaskDto;
import com.biz.crm.workflow.sdk.enums.EffectiveScopeEnum;
import com.biz.crm.workflow.sdk.enums.ProcessOperateTypeEnum;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ReplyCommunicationProcessButtonStrategy
extends AbstractLogButtonStrategy {
    private static final String PROCESS_BUTTON_DESC = "\u786e\u8ba4\u6c9f\u901a";
    @Autowired
    private ProcessTaskCommunicateService processTaskCommunicateService;

    public String getProcessButtonCode() {
        return StringUtils.uncapitalize((String)this.getClass().getSimpleName());
    }

    public String getProcessButtonDesc() {
        return PROCESS_BUTTON_DESC;
    }

    public Integer getIndex() {
        return 8;
    }

    @Transactional
    public void handleTask(TaskDto dto) {
        this.processTaskCommunicateService.completeCommunicateDto(dto);
        ProcessTaskLogDto processTaskLogDto = new ProcessTaskLogDto();
        processTaskLogDto.setTaskId(dto.getTaskId());
        processTaskLogDto.setProcessInstanceId(dto.getProcessInstanceId());
        processTaskLogDto.setOperateType(ProcessOperateTypeEnum.REPLY_COMMUNICATION.getDictCode());
        this.addLog(processTaskLogDto);
    }

    public String getProcessButtonType() {
        return EffectiveScopeEnum.ALL.getDictCode();
    }
}

