/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.workflow.local.strategy.button;

import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.workflow.local.dto.ProcessTaskLogDto;
import com.biz.crm.workflow.local.strategy.button.AbstractLogButtonStrategy;
import com.biz.crm.workflow.local.utils.FlowableUtils;
import com.biz.crm.workflow.sdk.dto.TaskDto;
import com.biz.crm.workflow.sdk.enums.EffectiveScopeEnum;
import com.biz.crm.workflow.sdk.enums.ProcessOperateTypeEnum;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.security.sdk.login.UserIdentity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.flowable.bpmn.model.BaseElement;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.Process;
import org.flowable.engine.HistoryService;
import org.flowable.engine.RepositoryService;
import org.flowable.engine.RuntimeService;
import org.flowable.engine.TaskService;
import org.flowable.engine.history.HistoricActivityInstance;
import org.flowable.engine.history.NativeHistoricActivityInstanceQuery;
import org.flowable.engine.repository.ProcessDefinition;
import org.flowable.engine.runtime.Execution;
import org.flowable.identitylink.api.IdentityLinkInfo;
import org.flowable.task.api.Task;
import org.flowable.task.api.TaskQuery;
import org.flowable.task.api.history.HistoricTaskInstance;
import org.flowable.task.api.history.HistoricTaskInstanceQuery;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class RollbackProcessButtonStrategy
extends AbstractLogButtonStrategy {
    @Autowired
    private TaskService taskService;
    @Autowired
    private HistoryService historyService;
    @Autowired
    private RepositoryService repositoryService;
    @Autowired
    private RuntimeService runtimeService;
    @Autowired
    private LoginUserService loginUserService;
    private static final String PROCESS_BUTTON_DESC = "\u56de\u9000";

    public String getProcessButtonCode() {
        return StringUtils.uncapitalize((String)this.getClass().getSimpleName());
    }

    public String getProcessButtonDesc() {
        return PROCESS_BUTTON_DESC;
    }

    public Integer getIndex() {
        return 3;
    }

    @Transactional
    public void handleTask(TaskDto dto) {
        List runExecutionList;
        List<String> runActivityIdList;
        List<FlowElement> currentFlowElementList;
        List<String> currentIds;
        Validate.notNull((Object)dto, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getTaskId(), (String)"\u4efb\u52a1\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getTargetKey(), (String)"\u56de\u9000\u76ee\u6807\u8282\u70b9\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getContent(), (String)"\u5ba1\u6279\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getProcessInstanceId(), (String)"\u5b9e\u4f8bid\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        UserIdentity userIdentity = this.loginUserService.getLoginUser();
        Validate.notNull((Object)userIdentity, (String)"\u83b7\u53d6\u767b\u5f55\u4eba\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)userIdentity.getTenantCode(), (String)"\u83b7\u53d6\u767b\u5f55\u4eba\u79df\u6237\u4fe1\u606f\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)userIdentity.getAccount(), (String)"\u83b7\u53d6\u5f53\u524d\u767b\u5f55\u4eba\u4fe1\u606f\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        String accout = StringUtils.join((Object[])new String[]{userIdentity.getIdentityType(), ":", userIdentity.getAccount()});
        Task task = (Task)((TaskQuery)((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().processInstanceId(dto.getProcessInstanceId())).taskTenantId(TenantUtils.getTenantCode())).taskId(dto.getTaskId())).singleResult();
        HistoricTaskInstance taskOld = (HistoricTaskInstance)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().taskTenantId(TenantUtils.getTenantCode())).taskId(dto.getTargetKey())).processInstanceId(dto.getProcessInstanceId())).singleResult();
        Validate.notNull((Object)task, (String)"\u5f53\u524d\u4efb\u52a1\u4e0d\u5b58\u5728,\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionId(task.getProcessDefinitionId()).singleResult();
        Process process = (Process)this.repositoryService.getBpmnModel(processDefinition.getId()).getProcesses().get(0);
        Collection<FlowElement> allElements = FlowableUtils.getAllElements(process.getFlowElements(), null);
        FlowElement source = null;
        FlowElement target = null;
        if (!CollectionUtils.isEmpty(allElements)) {
            for (FlowElement flowElement : allElements) {
                if (flowElement.getId().equals(task.getTaskDefinitionKey())) {
                    source = flowElement;
                }
                if (!flowElement.getId().equals(taskOld.getTaskDefinitionKey())) continue;
                target = flowElement;
            }
        }
        Validate.isTrue((!CollectionUtils.isEmpty(currentIds = (currentFlowElementList = FlowableUtils.iteratorFindChildUserTasks(target, runActivityIdList = (runExecutionList = this.runtimeService.createExecutionQuery().executionTenantId(TenantUtils.getTenantCode()).processInstanceId(task.getProcessInstanceId()).list()).stream().filter(execution -> StringUtils.isNotBlank((CharSequence)execution.getActivityId())).map(Execution::getActivityId).collect(Collectors.toList()), null, null)).stream().filter(execution -> StringUtils.isNotBlank((CharSequence)execution.getId())).map(BaseElement::getId).collect(Collectors.toList())) ? 1 : 0) != 0, (String)"\u64a4\u56de\u7f51\u5173\u8282\u70b9\u4e3a\u7a7a", (Object[])new Object[0]);
        AtomicReference listAtomicReference = new AtomicReference();
        ArrayList currentExecutionIds = new ArrayList();
        currentIds.forEach(currentId -> runExecutionList.forEach(runExecution -> {
            if (StringUtils.isNotBlank((CharSequence)runExecution.getActivityId()) && currentId.equals(runExecution.getActivityId())) {
                currentExecutionIds.add(runExecution.getId());
                listAtomicReference.set(this.historyService.createHistoricActivityInstanceQuery().activityTenantId(TenantUtils.getTenantCode()).processInstanceId(task.getProcessInstanceId()).executionId(runExecution.getId()).activityId(runExecution.getActivityId()).list());
                if (listAtomicReference.get() != null && ((List)listAtomicReference.get()).size() == 1 && StringUtils.isNotBlank((CharSequence)((HistoricActivityInstance)((List)listAtomicReference.get()).get(0)).getActivityType()) && ("parallelGateway".equals(((HistoricActivityInstance)((List)listAtomicReference.get()).get(0)).getActivityType()) || "inclusiveGateway".equals(((HistoricActivityInstance)((List)listAtomicReference.get()).get(0)).getActivityType()))) {
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("UPDATE ACT_HI_ACTINST SET DELETE_REASON_ = 'Change activity to ").append(dto.getTargetKey()).append("'  WHERE PROC_INST_ID_='").append(task.getProcessInstanceId()).append("' AND EXECUTION_ID_='").append(runExecution.getId()).append("' AND ACT_ID_='").append(runExecution.getActivityId()).append("'");
                    ((NativeHistoricActivityInstanceQuery)this.historyService.createNativeHistoricActivityInstanceQuery().sql(stringBuilder.toString())).singleResult();
                }
            }
        }));
        currentExecutionIds.forEach(item -> {
            Task userTask = (Task)((TaskQuery)((TaskQuery)((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().taskTenantId(TenantUtils.getTenantCode())).processInstanceId(dto.getProcessInstanceId())).includeIdentityLinks()).executionId(item)).singleResult();
            if (Objects.nonNull(userTask)) {
                this.taskService.addComment(userTask.getId(), task.getProcessInstanceId(), "taskStatus", "return");
                this.taskService.addComment(userTask.getId(), task.getProcessInstanceId(), "taskMessage", "\u5df2\u9000\u56de");
                this.taskService.addComment(userTask.getId(), task.getProcessInstanceId(), "taskComment", "\u6d41\u7a0b\u56de\u9000\u5230" + userTask.getName() + "\u8282\u70b9");
                this.taskService.setAssignee(userTask.getId(), accout);
                for (IdentityLinkInfo identityLink : userTask.getIdentityLinks()) {
                    this.taskService.deleteCandidateUser(userTask.getId(), identityLink.getUserId());
                    this.runtimeService.deleteUserIdentityLink(userTask.getProcessInstanceId(), identityLink.getUserId(), "participant");
                }
            }
        });
        this.runtimeService.createChangeActivityStateBuilder().processInstanceId(task.getProcessInstanceId()).moveActivityIdsToSingleActivityId(currentIds, taskOld.getTaskDefinitionKey()).changeState();
        ProcessTaskLogDto processTaskLogDto = new ProcessTaskLogDto();
        processTaskLogDto.setTaskId(dto.getTaskId());
        processTaskLogDto.setProcessInstanceId(dto.getProcessInstanceId());
        processTaskLogDto.setOperateType(ProcessOperateTypeEnum.ROLLBACK.getDictCode());
        processTaskLogDto.setTaskDefinitionKey(task.getTaskDefinitionKey());
        processTaskLogDto.setOperateRemark("\u8282\u70b9\u56de\u9000");
        this.addLog(processTaskLogDto);
    }

    public String getProcessButtonType() {
        return EffectiveScopeEnum.ALL.getDictCode();
    }
}

