/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.workflow.local.strategy.button;

import com.biz.crm.workflow.local.dto.ProcessTaskLogDto;
import com.biz.crm.workflow.local.service.ProcessInstanceFilesService;
import com.biz.crm.workflow.local.strategy.button.AbstractLogButtonStrategy;
import com.biz.crm.workflow.sdk.dto.TaskDto;
import com.biz.crm.workflow.sdk.enums.EffectiveScopeEnum;
import com.biz.crm.workflow.sdk.enums.ProcessOperateTypeEnum;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.Collection;
import java.util.List;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.flowable.engine.TaskService;
import org.flowable.task.api.Task;
import org.flowable.task.api.TaskQuery;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class UploadProcessButtonStrategy
extends AbstractLogButtonStrategy {
    @Autowired
    private ProcessInstanceFilesService processInstanceFilesService;
    private static final String PROCESS_BUTTON_DESC = "\u4e0a\u4f20\u6587\u4ef6";
    @Autowired
    private TaskService taskService;

    public String getProcessButtonCode() {
        return StringUtils.uncapitalize((String)this.getClass().getSimpleName());
    }

    public String getProcessButtonDesc() {
        return PROCESS_BUTTON_DESC;
    }

    public Integer getIndex() {
        return 7;
    }

    @Transactional
    public void handleTask(TaskDto dto) {
        if (dto != null && !CollectionUtils.isEmpty((Collection)dto.getProcessInstanceFiles())) {
            List processInstanceFilesDtos = dto.getProcessInstanceFiles();
            processInstanceFilesDtos.forEach(item -> {
                item.setProcessInstanceId(dto.getProcessInstanceId());
                item.setTenantCode(TenantUtils.getTenantCode());
                item.setTaskNodeId(dto.getTaskId());
            });
            this.processInstanceFilesService.createBatch(processInstanceFilesDtos);
            Task task = (Task)((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().processInstanceId(dto.getProcessInstanceId())).taskId(dto.getTaskId())).singleResult();
            ProcessTaskLogDto processTaskLogDto = new ProcessTaskLogDto();
            processTaskLogDto.setTaskId(dto.getTaskId());
            processTaskLogDto.setProcessInstanceId(dto.getProcessInstanceId());
            processTaskLogDto.setOperateType(ProcessOperateTypeEnum.UPLOAD.getDictCode());
            processTaskLogDto.setTaskDefinitionKey(task.getTaskDefinitionKey());
            processTaskLogDto.setOperateRemark(PROCESS_BUTTON_DESC);
            this.addLog(processTaskLogDto);
        }
    }

    public String getProcessButtonType() {
        return EffectiveScopeEnum.ALL.getDictCode();
    }
}

