/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.workflow.local.strategy.delegatemandatarytype;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.workflow.local.service.ProcessDelegateMandataryConfigDetailService;
import com.biz.crm.workflow.sdk.dto.ProcessDelegateConfigDto;
import com.biz.crm.workflow.sdk.dto.ProcessDelegateMandataryConfigDetailDto;
import com.biz.crm.workflow.sdk.dto.UserInfoEventDto;
import com.biz.crm.workflow.sdk.listener.UserInfoListener;
import com.biz.crm.workflow.sdk.strategy.delegatetype.ProcessDelegateMandataryTypeStrategy;
import com.biz.crm.workflow.sdk.vo.ProcessDelegateMandataryConfigDetailVo;
import com.biz.crm.workflow.sdk.vo.UserVo;
import com.biz.crm.workflow.sdk.vo.response.UserInfoResponse;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

public abstract class AbstractProcessDelegateMandataryTypeStrategy
implements ProcessDelegateMandataryTypeStrategy {
    @Autowired
    private ProcessDelegateMandataryConfigDetailService processDelegateMandataryConfigDetailService;
    @Autowired
    private NebulaNetEventClient nebulaNetEventClient;

    @Transactional
    public void deleteByDelegateConfigId(List<String> idList) {
        this.processDelegateMandataryConfigDetailService.deleteByConfigId(idList);
    }

    @Transactional
    public List<ProcessDelegateMandataryConfigDetailVo> onCreate(ProcessDelegateConfigDto processDelegateConfigDto) {
        String processDelegateTypeCode = this.getProcessDelegateTypeCode();
        List details = processDelegateConfigDto.getMandataryDetails();
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)details) ? 1 : 0) != 0, (String)"\u59d4\u6258\u4eba\u660e\u7ec6\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        String id = processDelegateConfigDto.getId();
        details.forEach(processDelegateConfigDetailDto -> processDelegateConfigDetailDto.setProcessDelegateConfigId(id));
        List<ProcessDelegateMandataryConfigDetailDto> collect = details.stream().filter(processDelegateConfigDetailDto -> processDelegateTypeCode.equals(processDelegateConfigDetailDto.getProcessDelegateTypeCode())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(collect)) {
            return null;
        }
        return this.processDelegateMandataryConfigDetailService.createBatch(collect);
    }

    @Transactional
    public List<ProcessDelegateMandataryConfigDetailVo> onUpdate(ProcessDelegateConfigDto processDelegateConfigDto) {
        String processDelegateTypeCode = this.getProcessDelegateTypeCode();
        List details = processDelegateConfigDto.getMandataryDetails();
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)details) ? 1 : 0) != 0, (String)"\u59d4\u6258\u4eba\u660e\u7ec6\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        String id = processDelegateConfigDto.getId();
        details.forEach(processDelegateConfigDetailDto -> processDelegateConfigDetailDto.setProcessDelegateConfigId(id));
        List<ProcessDelegateMandataryConfigDetailDto> collect = details.stream().filter(processDelegateConfigDetailDto -> processDelegateTypeCode.equals(processDelegateConfigDetailDto.getProcessDelegateTypeCode())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(collect)) {
            return null;
        }
        return this.processDelegateMandataryConfigDetailService.updateBatch(collect);
    }

    public List<ProcessDelegateMandataryConfigDetailVo> findByDelegateConfigId(String delegateConfigId) {
        String processDelegateTypeCode = this.getProcessDelegateTypeCode();
        return this.processDelegateMandataryConfigDetailService.findByConfigIdAndProcessDelegateTypeCode(delegateConfigId, processDelegateTypeCode);
    }

    protected Set<String> publishUserCodesRequestEvent(UserInfoEventDto dto, SerializableBiConsumer<UserInfoListener, UserInfoEventDto> sf) {
        UserInfoResponse userInfoResponse = (UserInfoResponse)this.nebulaNetEventClient.directPublish((NebulaEventDto)dto, UserInfoListener.class, sf);
        if (!Objects.isNull(userInfoResponse) && !CollectionUtils.isEmpty((Collection)userInfoResponse.getUserVos())) {
            Collection userVos = userInfoResponse.getUserVos();
            List<UserVo> userVoList = userVos.stream().filter(userVo -> DelFlagStatusEnum.NORMAL.getCode().equals(userVo.getDelFlag()) && EnableStatusEnum.ENABLE.getCode().equals(userVo.getEnableStatus())).collect(Collectors.toList());
            HashSet<String> userNames = new HashSet<String>();
            if (!CollectionUtils.isEmpty(userVoList)) {
                userVoList.forEach(userVo -> userNames.add(userVo.getIdentityType() + ":" + userVo.getUserName()));
            }
            return userNames;
        }
        return Collections.emptySet();
    }
}

