/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.workflow.local.strategy.delegatetype;

import com.biz.crm.workflow.local.service.ProcessDelegateConfigDetailService;
import com.biz.crm.workflow.sdk.dto.ProcessDelegateConfigDetailDto;
import com.biz.crm.workflow.sdk.dto.ProcessDelegateConfigDto;
import com.biz.crm.workflow.sdk.strategy.delegatetype.ProcessDelegateTypeStrategy;
import com.biz.crm.workflow.sdk.vo.ProcessDelegateConfigDetailVo;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

public abstract class AbstractProcessDelegateTypeStrategy
implements ProcessDelegateTypeStrategy {
    @Autowired
    private ProcessDelegateConfigDetailService processDelegateConfigDetailService;

    @Transactional
    public void deleteByDelegateConfigId(List<String> configIds) {
        this.processDelegateConfigDetailService.deleteByConfigId(configIds);
    }

    @Transactional
    public List<ProcessDelegateConfigDetailVo> onCreate(ProcessDelegateConfigDto processDelegateConfigDto) {
        String processDelegateTypeCode = this.getProcessDelegateTypeCode();
        List details = processDelegateConfigDto.getDetails();
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)details) ? 1 : 0) != 0, (String)"\u59d4\u6258\u4eba\u660e\u7ec6\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        String id = processDelegateConfigDto.getId();
        details.forEach(processDelegateConfigDetailDto -> processDelegateConfigDetailDto.setProcessDelegateConfigId(id));
        List<ProcessDelegateConfigDetailDto> collect = details.stream().filter(processDelegateConfigDetailDto -> processDelegateTypeCode.equals(processDelegateConfigDetailDto.getDelegatePersonType())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(collect)) {
            return null;
        }
        return this.processDelegateConfigDetailService.createBatch(collect);
    }

    @Transactional
    public List<ProcessDelegateConfigDetailVo> onUpdate(ProcessDelegateConfigDto processDelegateConfigDto) {
        String processDelegateTypeCode = this.getProcessDelegateTypeCode();
        List details = processDelegateConfigDto.getDetails();
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)details) ? 1 : 0) != 0, (String)"\u59d4\u6258\u4eba\u660e\u7ec6\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        String id = processDelegateConfigDto.getId();
        details.forEach(processDelegateConfigDetailDto -> processDelegateConfigDetailDto.setProcessDelegateConfigId(id));
        List<ProcessDelegateConfigDetailDto> collect = details.stream().filter(processDelegateConfigDetailDto -> processDelegateTypeCode.equals(processDelegateConfigDetailDto.getDelegatePersonType())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(collect)) {
            return null;
        }
        return this.processDelegateConfigDetailService.updateBatch(collect);
    }

    public List<ProcessDelegateConfigDetailVo> findByDelegateConfigId(String delegateConfigId) {
        String processDelegateTypeCode = this.getProcessDelegateTypeCode();
        return this.processDelegateConfigDetailService.findByConfigIdAndProcessDelegateTypeCode(delegateConfigId, processDelegateTypeCode);
    }
}

