/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.workflow.local.strategy.delegatetype;

import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.workflow.local.service.ProcessDelegateConfigDetailService;
import com.biz.crm.workflow.local.strategy.delegatetype.AbstractProcessDelegateTypeStrategy;
import com.biz.crm.workflow.sdk.dto.ProcessDelegateConfigDetailDto;
import com.biz.crm.workflow.sdk.dto.ProcessDelegateConfigDto;
import com.biz.crm.workflow.sdk.vo.ProcessDelegateConfigDetailVo;
import com.biz.crm.workflow.sdk.vo.WorkflowUserIdentity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class LoginProcessDelegateTypeStrategy
extends AbstractProcessDelegateTypeStrategy {
    @Autowired
    private LoginUserService loginUserService;
    @Autowired
    private ProcessDelegateConfigDetailService processDelegateConfigDetailService;
    private static final String APPLICATION_USER_SCOPE_NAME = "\u767b\u5f55\u4eba\u59d4\u6258";

    public String getProcessDelegateTypeCode() {
        return StringUtils.uncapitalize((String)this.getClass().getSimpleName());
    }

    public String getProcessDelegateTypeDesc() {
        return APPLICATION_USER_SCOPE_NAME;
    }

    public Integer getIndex() {
        return 0;
    }

    @Override
    public List<ProcessDelegateConfigDetailVo> onCreate(ProcessDelegateConfigDto processDelegateConfigDto) {
        WorkflowUserIdentity loginDetails = (WorkflowUserIdentity)this.loginUserService.getAbstractLoginUser();
        ArrayList<ProcessDelegateConfigDetailDto> details = new ArrayList<ProcessDelegateConfigDetailDto>();
        ProcessDelegateConfigDetailDto processDelegateConfigDetailDto = new ProcessDelegateConfigDetailDto();
        processDelegateConfigDetailDto.setProcessDelegateConfigId(processDelegateConfigDto.getId());
        processDelegateConfigDetailDto.setCode(loginDetails.getIdentityType() + ":" + loginDetails.getUserName());
        processDelegateConfigDetailDto.setName(loginDetails.getRealName());
        processDelegateConfigDetailDto.setDelegatePersonType(this.getProcessDelegateTypeCode());
        details.add(processDelegateConfigDetailDto);
        return this.processDelegateConfigDetailService.createBatch(details);
    }

    @Override
    @Transactional
    public List<ProcessDelegateConfigDetailVo> onUpdate(ProcessDelegateConfigDto processDelegateConfigDto) {
        WorkflowUserIdentity loginDetails = (WorkflowUserIdentity)this.loginUserService.getAbstractLoginUser();
        ArrayList<ProcessDelegateConfigDetailDto> details = new ArrayList<ProcessDelegateConfigDetailDto>();
        ProcessDelegateConfigDetailDto processDelegateConfigDetailDto = new ProcessDelegateConfigDetailDto();
        processDelegateConfigDetailDto.setProcessDelegateConfigId(processDelegateConfigDto.getId());
        processDelegateConfigDetailDto.setCode(loginDetails.getIdentityType() + ":" + loginDetails.getUserName());
        processDelegateConfigDetailDto.setName(loginDetails.getRealName());
        processDelegateConfigDetailDto.setDelegatePersonType(this.getProcessDelegateTypeCode());
        details.add(processDelegateConfigDetailDto);
        return this.processDelegateConfigDetailService.updateBatch(details);
    }

    public Set<String> onHandle(Collection<String> codes) {
        Validate.notEmpty(codes, (String)"\u67e5\u8be2\u7528\u6237\u53c2\u6570\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        return (Set)codes;
    }
}

