/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.workflow.local.strategy.scope;

import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.workflow.local.entity.ProcessTemplateScope;
import com.biz.crm.workflow.local.service.ProcessTemplateScopeService;
import com.biz.crm.workflow.sdk.strategy.scope.ApplicationUserScopeStrategy;
import com.biz.crm.workflow.sdk.vo.ProcessTemplateScopeVo;
import com.biz.crm.workflow.sdk.vo.ProcessTemplateVo;
import com.biz.crm.workflow.sdk.vo.WorkflowUserIdentity;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class OrgApplicationUserScopeStrategy
implements ApplicationUserScopeStrategy {
    @Autowired
    private ProcessTemplateScopeService processTemplateScopeService;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private LoginUserService loginUserService;
    private static final String APPLICATION_USER_SCOPE_NAME = "\u7ec4\u7ec7";

    public String getProcessUserScopeType() {
        return StringUtils.uncapitalize((String)this.getClass().getSimpleName());
    }

    public String getProcessUserScopeDesc() {
        return APPLICATION_USER_SCOPE_NAME;
    }

    public Integer getIndex() {
        return 3;
    }

    public void onSaveApplicationUserScopeInfo(boolean update, ProcessTemplateVo currentProcessTemplate, ProcessTemplateVo oldProcessTemplate) {
        Validate.notNull((Object)currentProcessTemplate, (String)"\u7f16\u8f91\u7684\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)currentProcessTemplate.getProcessTemplateScopes()) ? 1 : 0) != 0, (String)"\u7f16\u8f91\u7684\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List managementApplicationScopeList = (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)currentProcessTemplate.getProcessTemplateScopes(), ProcessTemplateScopeVo.class, ProcessTemplateScope.class, HashSet.class, ArrayList.class, new String[0]);
        if (update) {
            this.processTemplateScopeService.deleteByProcessTemplateId(oldProcessTemplate.getId());
        }
        managementApplicationScopeList.forEach(processTemplateApplicationScope -> {
            processTemplateApplicationScope.setProcessTemplateId(currentProcessTemplate.getId());
            processTemplateApplicationScope.setProcessUserScopeType(this.getProcessUserScopeType());
            processTemplateApplicationScope.setId(null);
        });
        this.processTemplateScopeService.createBatch(managementApplicationScopeList);
    }

    public Set<String> onRequestProcessByLoginDetail() {
        WorkflowUserIdentity loginDetails = (WorkflowUserIdentity)this.loginUserService.getAbstractLoginUser();
        Validate.notNull((Object)loginDetails, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        String loginDetailsOrgCode = loginDetails.getOrgCode();
        if (!StringUtils.isBlank((CharSequence)loginDetailsOrgCode)) {
            return this.processTemplateScopeService.findProcessTemplateIdsByScopeCode(Collections.singleton(loginDetailsOrgCode), this.getProcessUserScopeType());
        }
        return null;
    }
}

