/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.workflow.local.strategy.sms.sms;

import com.aliyun.dysmsapi20170525.Client;
import com.aliyun.dysmsapi20170525.models.SendSmsRequest;
import com.aliyun.dysmsapi20170525.models.SendSmsResponse;
import com.aliyun.teaopenapi.models.Config;
import com.biz.crm.workflow.sdk.strategy.sms.SmsStrategy;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class AliyunSmsStrategy
implements SmsStrategy {
    private static final Logger log = LoggerFactory.getLogger(AliyunSmsStrategy.class);
    @Value(value="${sms.supplier:}")
    private String supplier;
    @Value(value="${sms.endpoint:}")
    private String endpoint;
    @Value(value="${sms.accessKeyId:}")
    private String accessKeyId;
    @Value(value="${sms.accessKeySecret:}")
    private String accessKeySecret;
    @Value(value="${sms.signName:}")
    private String signName;

    public String getSmsCode() {
        return this.getClass().getSimpleName();
    }

    public String getSmsName() {
        return "\u963f\u91cc\u4e91\u77ed\u4fe1\u5e73\u53f0";
    }

    public void sendSms(String phone, String templateId, String content) {
        if (this.currentSupplier().equals(this.supplier)) {
            Validate.notNull((Object)phone, (String)"\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notNull((Object)content, (String)"\u77ed\u4fe1\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            SendSmsRequest sendSmsRequest = new SendSmsRequest();
            sendSmsRequest.setSignName(this.signName);
            sendSmsRequest.setPhoneNumbers(phone);
            sendSmsRequest.setTemplateCode(templateId);
            sendSmsRequest.setTemplateParam(content);
            this.aliyunSendSms(sendSmsRequest);
        }
    }

    private Client createClient(String accessKeyId, String accessKeySecret, String endpoint) {
        Config config = new Config().setAccessKeyId(accessKeyId).setAccessKeySecret(accessKeySecret).setEndpoint(endpoint);
        Client client = null;
        try {
            client = new Client(config);
        }
        catch (Exception e) {
            throw new RuntimeException("\u521b\u5efa\u963f\u91cc\u4e91\u77ed\u4fe1\u94fe\u63a5\u5f02\u5e38\uff01");
        }
        return client;
    }

    private void aliyunSendSms(SendSmsRequest sendSmsRequest) {
        try {
            Client client = this.createClient(this.accessKeyId, this.accessKeySecret, this.endpoint);
            SendSmsResponse resp = client.sendSms(sendSmsRequest);
            String success = "OK";
            Validate.isTrue((boolean)StringUtils.equals((CharSequence)resp.body.code, (CharSequence)success), (String)resp.body.message, (Object[])new Object[0]);
        }
        catch (Exception e) {
            log.error("\u77ed\u4fe1\u53d1\u9001\u5f02\u5e38\uff1a{}", (Object)e.getMessage(), (Object)e);
            Validate.isTrue((boolean)Boolean.FALSE, (String)"\u77ed\u4fe1\u53d1\u9001\u5f02\u5e38\uff1a%s", (Object[])new Object[]{e.getMessage()});
        }
    }

    private String currentSupplier() {
        return "aliyun";
    }
}

