/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.workflow.local.strategy.sms.smstouser;

import com.biz.crm.workflow.local.service.ProcessTemplateNodeSmsUserService;
import com.biz.crm.workflow.sdk.dto.CustomerInfoDto;
import com.biz.crm.workflow.sdk.dto.ProcessTemplateNodeSmsUserDto;
import com.biz.crm.workflow.sdk.listener.CustomerInfoListener;
import com.biz.crm.workflow.sdk.strategy.sms.SmsToUserStrategy;
import com.biz.crm.workflow.sdk.vo.ProcessTemplateNodeSmsUserVo;
import com.biz.crm.workflow.sdk.vo.response.CustomerInfoResponse;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class CustomerSmsToUserStrategy
implements SmsToUserStrategy {
    @Autowired
    private ProcessTemplateNodeSmsUserService processTemplateNodeSmsUserService;
    @Autowired
    private NebulaNetEventClient nebulaNetEventClient;

    public String getSmsToUserTypeCode() {
        return this.getClass().getSimpleName();
    }

    public String getSmsToUserTypeName() {
        return "\u6307\u5b9a\u5ba2\u6237\u53d1\u9001";
    }

    public Set<String> getSmsPhone(Collection<ProcessTemplateNodeSmsUserVo> processTemplateNodeSmsUserVos) {
        if (!CollectionUtils.isEmpty(processTemplateNodeSmsUserVos)) {
            List customerCodes = processTemplateNodeSmsUserVos.stream().map(ProcessTemplateNodeSmsUserVo::getBusinessUserCode).collect(Collectors.toList());
            SerializableBiConsumer & Serializable sf = CustomerInfoListener::findByCustomerCodes;
            CustomerInfoResponse customerInfoResponse = (CustomerInfoResponse)this.nebulaNetEventClient.directPublish((NebulaEventDto)CustomerInfoDto.builder().customerCodes((List)Lists.newArrayList(customerCodes)).build(), CustomerInfoListener.class, (SerializableBiConsumer)sf);
            if (Objects.nonNull(customerInfoResponse)) {
                HashSet<String> phone = new HashSet<String>();
                Collection customerVos = customerInfoResponse.getCustomerVos();
                customerVos.forEach(customerVo -> {
                    List contactList = customerVo.getContactList();
                    contactList.forEach(customerContactVo -> {
                        if (customerContactVo.getContactMain().booleanValue()) {
                            phone.add(customerContactVo.getContactPhone());
                        }
                    });
                });
                return phone;
            }
        }
        return null;
    }

    public void onSaveSmsToUserBatchInfo(Collection<ProcessTemplateNodeSmsUserDto> processTemplateNodeSmsUserDtos) {
        Validate.isTrue((!CollectionUtils.isEmpty(processTemplateNodeSmsUserDtos) ? 1 : 0) != 0, (String)"\u77ed\u4fe1\u8282\u70b9\u65b0\u589e\u53d1\u9001\u4eba\u65f6\uff0c\u6570\u636e\u4e3a\u7a7a", (Object[])new Object[0]);
        processTemplateNodeSmsUserDtos.forEach(processTemplateNodeSmsUserDto -> Validate.notBlank((CharSequence)processTemplateNodeSmsUserDto.getPhone(), (String)"\u77ed\u4fe1\u8282\u70b9%s\u65f6,\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[]{this.getSmsToUserTypeName()}));
        this.processTemplateNodeSmsUserService.createBatch(processTemplateNodeSmsUserDtos);
    }
}

