/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.workflow.local.strategy.tracing;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.workflow.sdk.dto.UserInfoEventDto;
import com.biz.crm.workflow.sdk.listener.CustomerUserInfoListener;
import com.biz.crm.workflow.sdk.listener.TerminalUserInfoListener;
import com.biz.crm.workflow.sdk.listener.UserInfoListener;
import com.biz.crm.workflow.sdk.strategy.tracing.TracingStrategy;
import com.biz.crm.workflow.sdk.vo.UserVo;
import com.biz.crm.workflow.sdk.vo.response.UserInfoResponse;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

public abstract class AbstractTracingStrategy
implements TracingStrategy {
    @Autowired
    private NebulaNetEventClient nebulaNetEventClient;

    protected Set<String> publishUserCodesRequestEvent(UserInfoEventDto dto, SerializableBiConsumer<UserInfoListener, UserInfoEventDto> sf) {
        UserInfoResponse userInfoResponse = (UserInfoResponse)this.nebulaNetEventClient.directPublish((NebulaEventDto)dto, UserInfoListener.class, sf);
        if (!Objects.isNull(userInfoResponse) && !CollectionUtils.isEmpty((Collection)userInfoResponse.getUserVos())) {
            Collection userVos = userInfoResponse.getUserVos();
            List<UserVo> userVoList = userVos.stream().filter(userVo -> DelFlagStatusEnum.NORMAL.getCode().equals(userVo.getDelFlag()) && EnableStatusEnum.ENABLE.getCode().equals(userVo.getEnableStatus())).collect(Collectors.toList());
            HashSet<String> userNames = new HashSet<String>();
            if (!CollectionUtils.isEmpty(userVoList)) {
                userVoList.forEach(userVo -> userNames.add(userVo.getIdentityType() + ":" + userVo.getUserName()));
            }
            return userNames;
        }
        return Collections.emptySet();
    }

    protected Set<UserVo> publishUserVosRequestEvent(UserInfoEventDto dto, SerializableBiConsumer<UserInfoListener, UserInfoEventDto> sf) {
        UserInfoResponse userInfoResponse = (UserInfoResponse)this.nebulaNetEventClient.directPublish((NebulaEventDto)dto, UserInfoListener.class, sf);
        if (!Objects.isNull(userInfoResponse) && !CollectionUtils.isEmpty((Collection)userInfoResponse.getUserVos())) {
            Collection userVos = userInfoResponse.getUserVos();
            Set<UserVo> userVoList = userVos.stream().filter(userVo -> DelFlagStatusEnum.NORMAL.getCode().equals(userVo.getDelFlag()) && EnableStatusEnum.ENABLE.getCode().equals(userVo.getEnableStatus())).collect(Collectors.toSet());
            return userVoList;
        }
        return Collections.emptySet();
    }

    protected Set<String> publishCusUserCodesRequestEvent(UserInfoEventDto dto, SerializableBiConsumer<CustomerUserInfoListener, UserInfoEventDto> sf) {
        UserInfoResponse userInfoResponse = (UserInfoResponse)this.nebulaNetEventClient.directPublish((NebulaEventDto)dto, CustomerUserInfoListener.class, sf);
        if (!Objects.isNull(userInfoResponse) && !CollectionUtils.isEmpty((Collection)userInfoResponse.getUserVos())) {
            Collection userVos = userInfoResponse.getUserVos();
            HashSet<String> userNames = new HashSet<String>();
            userVos.forEach(userVo -> userNames.add(userVo.getIdentityType() + ":" + userVo.getUserName()));
            return userNames;
        }
        return Collections.emptySet();
    }

    protected Set<UserVo> publishCusUserVosRequestEvent(UserInfoEventDto dto, SerializableBiConsumer<CustomerUserInfoListener, UserInfoEventDto> sf) {
        UserInfoResponse userInfoResponse = (UserInfoResponse)this.nebulaNetEventClient.directPublish((NebulaEventDto)dto, CustomerUserInfoListener.class, sf);
        if (!Objects.isNull(userInfoResponse) && !CollectionUtils.isEmpty((Collection)userInfoResponse.getUserVos())) {
            Collection userVos = userInfoResponse.getUserVos();
            Set<UserVo> userVoList = userVos.stream().filter(userVo -> DelFlagStatusEnum.NORMAL.getCode().equals(userVo.getDelFlag()) && EnableStatusEnum.ENABLE.getCode().equals(userVo.getEnableStatus())).collect(Collectors.toSet());
            return userVoList;
        }
        return Collections.emptySet();
    }

    protected Set<UserVo> publishTerUserVosRequestEvent(UserInfoEventDto dto, SerializableBiConsumer<TerminalUserInfoListener, UserInfoEventDto> sf) {
        UserInfoResponse userInfoResponse = (UserInfoResponse)this.nebulaNetEventClient.directPublish((NebulaEventDto)dto, TerminalUserInfoListener.class, sf);
        if (!Objects.isNull(userInfoResponse) && !CollectionUtils.isEmpty((Collection)userInfoResponse.getUserVos())) {
            Collection userVos = userInfoResponse.getUserVos();
            Set<UserVo> userVoList = userVos.stream().filter(userVo -> DelFlagStatusEnum.NORMAL.getCode().equals(userVo.getDelFlag()) && EnableStatusEnum.ENABLE.getCode().equals(userVo.getEnableStatus())).collect(Collectors.toSet());
            return userVoList;
        }
        return Collections.emptySet();
    }

    protected Set<String> publishTerUserCodesRequestEvent(UserInfoEventDto dto, SerializableBiConsumer<TerminalUserInfoListener, UserInfoEventDto> sf) {
        UserInfoResponse userInfoResponse = (UserInfoResponse)this.nebulaNetEventClient.directPublish((NebulaEventDto)dto, TerminalUserInfoListener.class, sf);
        if (!Objects.isNull(userInfoResponse) && !CollectionUtils.isEmpty((Collection)userInfoResponse.getUserVos())) {
            Collection userVos = userInfoResponse.getUserVos();
            HashSet<String> userNames = new HashSet<String>();
            userVos.forEach(userVo -> userNames.add(userVo.getIdentityType() + ":" + userVo.getUserName()));
            return userNames;
        }
        return Collections.emptySet();
    }

    protected Collection<String> buildUserNames(Collection<String> codes) {
        Validate.notEmpty(codes, (String)"\u67e5\u8be2\u7528\u6237\u53c2\u6570\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        long size = codes.stream().filter(StringUtils::isNotBlank).count();
        Validate.isTrue((size > 0L ? 1 : 0) != 0, (String)"\u67e5\u8be2\u7528\u6237\u53c2\u6570\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        codes = codes.stream().filter(StringUtils::isNotBlank).collect(Collectors.toSet());
        return codes;
    }
}

