/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.workflow.local.strategy.tracing;

import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.workflow.local.strategy.tracing.AbstractTracingStrategy;
import com.biz.crm.workflow.sdk.dto.UserInfoEventDto;
import com.biz.crm.workflow.sdk.listener.UserInfoListener;
import com.biz.crm.workflow.sdk.vo.UserVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.security.sdk.login.UserIdentity;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.SequenceFlow;
import org.flowable.bpmn.model.StartEvent;
import org.flowable.bpmn.model.UserTask;
import org.flowable.engine.HistoryService;
import org.flowable.engine.RepositoryService;
import org.flowable.engine.TaskService;
import org.flowable.task.api.Task;
import org.flowable.task.api.TaskQuery;
import org.flowable.task.api.history.HistoricTaskInstance;
import org.flowable.task.api.history.HistoricTaskInstanceQuery;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PreNodeApproverUpperTracingStrategy
extends AbstractTracingStrategy {
    @Autowired
    private TaskService taskService;
    @Autowired
    private HistoryService historyService;
    @Autowired
    private LoginUserService loginUserService;
    @Autowired
    private RepositoryService repositoryService;

    public String getCode() {
        return this.getClass().getSimpleName();
    }

    public String getName() {
        return "\u4e0a\u4e00\u8282\u70b9\u5ba1\u6279\u4eba\u4e0a\u7ea7";
    }

    public Set<String> onHandle(Collection<String> codes, String taskDefinitionKey, String taskId, String processInstanceId, String startUserName) {
        Validate.isTrue((StringUtils.isNotBlank((CharSequence)taskId) || StringUtils.isNotBlank((CharSequence)processInstanceId) ? 1 : 0) != 0, (String)"\u4efb\u52a1id\u6216\u8005\u5b9e\u4f8bid\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)taskDefinitionKey, (String)"\u6267\u884c\u5bfb\u4eba\u65f6\uff0c\u4e0a\u4e00\u8282\u70b9\u5ba1\u6279\u4eba\u4e0a\u7ea7\u9700\u8981\u4f20\u5165\u8282\u70b9key\uff01", (Object[])new Object[0]);
        List<Object> historicTaskInstances = new ArrayList();
        if (StringUtils.isNotBlank((CharSequence)taskId)) {
            Task task = (Task)((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().taskTenantId(TenantUtils.getTenantCode())).taskId(taskId)).singleResult();
            if (ObjectUtils.isEmpty((Object)task)) {
                AbstractCrmUserIdentity userIdentity = this.loginUserService.getAbstractLoginUser();
                String userCode = StringUtils.join((Object[])new String[]{userIdentity.getIdentityType(), ":", userIdentity.getAccount()});
                return Sets.newHashSet((Object[])new String[]{userCode});
            }
            historicTaskInstances = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().taskTenantId(TenantUtils.getTenantCode())).processInstanceId(task.getProcessInstanceId())).list();
        } else {
            historicTaskInstances = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().taskTenantId(TenantUtils.getTenantCode())).processInstanceId(processInstanceId)).list();
        }
        HistoricTaskInstance taskInstance = null;
        if (!historicTaskInstances.isEmpty() && !(historicTaskInstances = historicTaskInstances.stream().filter(historicTaskInstance -> Objects.nonNull(historicTaskInstance.getEndTime()) && !taskDefinitionKey.equals(historicTaskInstance.getTaskDefinitionKey()) && StringUtils.isNotBlank((CharSequence)historicTaskInstance.getAssignee())).sorted(Comparator.comparing(HistoricTaskInstance::getEndTime).reversed()).collect(Collectors.toList())).isEmpty() && ((HistoricTaskInstance)historicTaskInstances.get(0)).getEndTime() != null) {
            taskInstance = (HistoricTaskInstance)historicTaskInstances.get(0);
        }
        if (ObjectUtils.isNotEmpty(taskInstance) && StringUtils.isNotEmpty((CharSequence)taskInstance.getAssignee())) {
            SerializableBiConsumer & Serializable sf = UserInfoListener::findByPositionUpperByUserCode;
            UserInfoEventDto userInfoEventDto = UserInfoEventDto.builder().userCode(taskInstance.getAssignee().split(":")[1]).build();
            return this.publishUserCodesRequestEvent(userInfoEventDto, (SerializableBiConsumer<UserInfoListener, UserInfoEventDto>)sf);
        }
        String processDefinitionId = ((Task)((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).taskTenantId(TenantUtils.getTenantCode())).singleResult()).getProcessDefinitionId();
        BpmnModel bpmnModel = this.repositoryService.getBpmnModel(processDefinitionId);
        Collection flowElements = bpmnModel.getMainProcess().getFlowElements();
        for (FlowElement flowElement : flowElements) {
            List incomingFlows;
            Iterator iterator;
            if (!(flowElement instanceof UserTask) || !flowElement.getId().equals(taskDefinitionKey) || !(iterator = (incomingFlows = ((UserTask)flowElement).getIncomingFlows()).iterator()).hasNext()) continue;
            SequenceFlow incomingFlow = (SequenceFlow)iterator.next();
            FlowElement sourceFlowElement = incomingFlow.getSourceFlowElement();
            if (sourceFlowElement instanceof StartEvent) {
                UserIdentity loginUser = this.loginUserService.getLoginUser();
                String userCode = loginUser.getAccount();
                SerializableBiConsumer & Serializable sf = UserInfoListener::findByPositionUpperByUserCode;
                UserInfoEventDto userInfoEventDto = UserInfoEventDto.builder().userCode(userCode).build();
                return this.publishUserCodesRequestEvent(userInfoEventDto, (SerializableBiConsumer<UserInfoListener, UserInfoEventDto>)sf);
            }
            return new HashSet<String>();
        }
        return new HashSet<String>();
    }

    public Set<UserVo> onHandleUserVos(Collection<String> codes, String taskId, String processInstanceId, String startUserName) {
        if (StringUtils.isBlank((CharSequence)taskId) && StringUtils.isBlank((CharSequence)processInstanceId)) {
            return null;
        }
        List<Object> historicTaskInstances = new ArrayList();
        if (StringUtils.isNotBlank((CharSequence)taskId)) {
            Task task = (Task)((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().taskTenantId(TenantUtils.getTenantCode())).taskId(taskId)).singleResult();
            if (ObjectUtils.isEmpty((Object)task)) {
                return Collections.singleton(this.buildUserVo());
            }
            historicTaskInstances = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().taskTenantId(TenantUtils.getTenantCode())).processInstanceId(task.getProcessInstanceId())).list();
        } else {
            historicTaskInstances = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().taskTenantId(TenantUtils.getTenantCode())).processInstanceId(processInstanceId)).list();
        }
        HistoricTaskInstance taskInstance = null;
        if (!historicTaskInstances.isEmpty() && ((HistoricTaskInstance)(historicTaskInstances = historicTaskInstances.stream().filter(historicTaskInstance -> Objects.nonNull(historicTaskInstance.getEndTime())).sorted(Comparator.comparing(HistoricTaskInstance::getEndTime).reversed()).collect(Collectors.toList())).get(0)).getEndTime() != null) {
            taskInstance = (HistoricTaskInstance)historicTaskInstances.get(0);
        }
        Validate.notNull(taskInstance, (String)"\u4e0a\u4e00\u8282\u70b9\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        SerializableBiConsumer & Serializable sf = UserInfoListener::findByPositionUpperByUserCode;
        UserInfoEventDto userInfoEventDto = UserInfoEventDto.builder().userCode(taskInstance.getAssignee().split(":")[1]).build();
        return this.publishUserVosRequestEvent(userInfoEventDto, (SerializableBiConsumer<UserInfoListener, UserInfoEventDto>)sf);
    }

    public int getOrder() {
        return 4;
    }

    private UserVo buildUserVo() {
        AbstractCrmUserIdentity userIdentity = this.loginUserService.getAbstractLoginUser();
        UserVo userVo = new UserVo();
        userVo.setIdentityType(userIdentity.getIdentityType());
        userVo.setUserCode(userIdentity.getUsername());
        userVo.setUserName(userIdentity.getRealName());
        return userVo;
    }
}

