/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.workflow.local.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.flowable.bpmn.model.EndEvent;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.Gateway;
import org.flowable.bpmn.model.SequenceFlow;
import org.flowable.bpmn.model.StartEvent;
import org.flowable.bpmn.model.SubProcess;
import org.flowable.bpmn.model.Task;
import org.flowable.bpmn.model.UserTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlowableUtils {
    private static final Logger log = LoggerFactory.getLogger(FlowableUtils.class);

    public static List<SequenceFlow> getElementIncomingFlows(FlowElement source) {
        List sequenceFlows = null;
        if (source instanceof Task) {
            sequenceFlows = ((Task)source).getIncomingFlows();
        } else if (source instanceof Gateway) {
            sequenceFlows = ((Gateway)source).getIncomingFlows();
        } else if (source instanceof SubProcess) {
            sequenceFlows = ((SubProcess)source).getIncomingFlows();
        } else if (source instanceof StartEvent) {
            sequenceFlows = ((StartEvent)source).getIncomingFlows();
        } else if (source instanceof EndEvent) {
            sequenceFlows = ((EndEvent)source).getIncomingFlows();
        }
        return sequenceFlows;
    }

    public static List<SequenceFlow> getElementOutgoingFlows(FlowElement source) {
        List sequenceFlows = null;
        if (source instanceof Task) {
            sequenceFlows = ((Task)source).getOutgoingFlows();
        } else if (source instanceof Gateway) {
            sequenceFlows = ((Gateway)source).getOutgoingFlows();
        } else if (source instanceof SubProcess) {
            sequenceFlows = ((SubProcess)source).getOutgoingFlows();
        } else if (source instanceof StartEvent) {
            sequenceFlows = ((StartEvent)source).getOutgoingFlows();
        } else if (source instanceof EndEvent) {
            sequenceFlows = ((EndEvent)source).getOutgoingFlows();
        }
        return sequenceFlows;
    }

    public static Collection<FlowElement> getAllElements(Collection<FlowElement> flowElements, Collection<FlowElement> allElements) {
        allElements = allElements == null ? new ArrayList<FlowElement>() : allElements;
        for (FlowElement flowElement : flowElements) {
            allElements.add(flowElement);
            if (!(flowElement instanceof SubProcess)) continue;
            allElements = FlowableUtils.getAllElements(((SubProcess)flowElement).getFlowElements(), allElements);
        }
        return allElements;
    }

    public static List<FlowElement> iteratorFindChildUserTasks(FlowElement source, List<String> runActiveIdList, Set<String> hasSequenceFlow, List<FlowElement> flowElementList) {
        List<SequenceFlow> sequenceFlows;
        hasSequenceFlow = hasSequenceFlow == null ? new HashSet<String>() : hasSequenceFlow;
        List<FlowElement> list = flowElementList = flowElementList == null ? new ArrayList<FlowElement>() : flowElementList;
        if (source instanceof EndEvent && source.getSubProcess() != null) {
            flowElementList = FlowableUtils.iteratorFindChildUserTasks((FlowElement)source.getSubProcess(), runActiveIdList, hasSequenceFlow, flowElementList);
        }
        if ((sequenceFlows = FlowableUtils.getElementOutgoingFlows(source)) != null) {
            for (SequenceFlow sequenceFlow : sequenceFlows) {
                List<FlowElement> childUserTaskList;
                if (hasSequenceFlow.contains(sequenceFlow.getId())) continue;
                hasSequenceFlow.add(sequenceFlow.getId());
                if ((sequenceFlow.getTargetFlowElement() instanceof UserTask || sequenceFlow.getTargetFlowElement() instanceof Gateway) && runActiveIdList.contains(sequenceFlow.getTargetFlowElement().getId())) {
                    flowElementList.add(sequenceFlow.getTargetFlowElement());
                    continue;
                }
                if (sequenceFlow.getTargetFlowElement() instanceof SubProcess && (childUserTaskList = FlowableUtils.iteratorFindChildUserTasks((FlowElement)((SubProcess)sequenceFlow.getTargetFlowElement()).getFlowElements().toArray()[0], runActiveIdList, hasSequenceFlow, null)) != null && childUserTaskList.size() > 0) {
                    flowElementList.addAll(childUserTaskList);
                    continue;
                }
                flowElementList = FlowableUtils.iteratorFindChildUserTasks(sequenceFlow.getTargetFlowElement(), runActiveIdList, new HashSet<String>(hasSequenceFlow), flowElementList);
            }
        }
        return flowElementList;
    }

    public static Set<String> findChildProcessAllDirtyRoad(FlowElement source, Set<String> hasSequenceFlow, Set<String> dirtyRoads) {
        hasSequenceFlow = hasSequenceFlow == null ? new HashSet<String>() : hasSequenceFlow;
        dirtyRoads = dirtyRoads == null ? new HashSet<String>() : dirtyRoads;
        List<SequenceFlow> sequenceFlows = FlowableUtils.getElementOutgoingFlows(source);
        if (sequenceFlows != null) {
            for (SequenceFlow sequenceFlow : sequenceFlows) {
                if (hasSequenceFlow.contains(sequenceFlow.getId())) continue;
                hasSequenceFlow.add(sequenceFlow.getId());
                dirtyRoads.add(sequenceFlow.getTargetFlowElement().getId());
                if (sequenceFlow.getTargetFlowElement() instanceof SubProcess) {
                    dirtyRoads = FlowableUtils.findChildProcessAllDirtyRoad((FlowElement)((SubProcess)sequenceFlow.getTargetFlowElement()).getFlowElements().toArray()[0], hasSequenceFlow, dirtyRoads);
                }
                dirtyRoads = FlowableUtils.findChildProcessAllDirtyRoad(sequenceFlow.getTargetFlowElement(), new HashSet<String>(hasSequenceFlow), dirtyRoads);
            }
        }
        return dirtyRoads;
    }

    public static Boolean dirtyTargetInChildProcess(FlowElement source, Set<String> hasSequenceFlow, List<String> targets, Boolean inChildProcess) {
        hasSequenceFlow = hasSequenceFlow == null ? new HashSet<String>() : hasSequenceFlow;
        inChildProcess = inChildProcess == null ? false : inChildProcess;
        List<SequenceFlow> sequenceFlows = FlowableUtils.getElementOutgoingFlows(source);
        if (sequenceFlows != null && !inChildProcess.booleanValue()) {
            for (SequenceFlow sequenceFlow : sequenceFlows) {
                if (hasSequenceFlow.contains(sequenceFlow.getId())) continue;
                hasSequenceFlow.add(sequenceFlow.getId());
                if (targets.contains(sequenceFlow.getTargetFlowElement().getId())) {
                    inChildProcess = true;
                    break;
                }
                if (sequenceFlow.getTargetFlowElement() instanceof SubProcess) {
                    inChildProcess = FlowableUtils.dirtyTargetInChildProcess((FlowElement)((SubProcess)sequenceFlow.getTargetFlowElement()).getFlowElements().toArray()[0], hasSequenceFlow, targets, inChildProcess);
                }
                inChildProcess = FlowableUtils.dirtyTargetInChildProcess(sequenceFlow.getTargetFlowElement(), new HashSet<String>(hasSequenceFlow), targets, inChildProcess);
            }
        }
        return inChildProcess;
    }

    public static Boolean iteratorCheckSequentialReferTarget(FlowElement source, String targetKsy, Set<String> hasSequenceFlow, Boolean isSequential) {
        List<SequenceFlow> sequenceFlows;
        isSequential = isSequential == null ? true : isSequential;
        HashSet<String> hashSet = hasSequenceFlow = hasSequenceFlow == null ? new HashSet<String>() : hasSequenceFlow;
        if (source instanceof StartEvent && source.getSubProcess() != null) {
            isSequential = FlowableUtils.iteratorCheckSequentialReferTarget((FlowElement)source.getSubProcess(), targetKsy, hasSequenceFlow, isSequential);
        }
        if ((sequenceFlows = FlowableUtils.getElementIncomingFlows(source)) != null) {
            for (SequenceFlow sequenceFlow : sequenceFlows) {
                if (hasSequenceFlow.contains(sequenceFlow.getId())) continue;
                hasSequenceFlow.add(sequenceFlow.getId());
                if (!isSequential.booleanValue()) break;
                if (targetKsy.equals(sequenceFlow.getSourceFlowElement().getId())) continue;
                if (sequenceFlow.getSourceFlowElement() instanceof StartEvent) {
                    isSequential = false;
                    break;
                }
                isSequential = FlowableUtils.iteratorCheckSequentialReferTarget(sequenceFlow.getSourceFlowElement(), targetKsy, new HashSet<String>(hasSequenceFlow), isSequential);
            }
        }
        return isSequential;
    }
}

