/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.workflow.local.validator;

import com.biz.crm.workflow.local.service.ProcessService;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.EndEvent;
import org.flowable.bpmn.model.Process;
import org.flowable.bpmn.model.StartEvent;
import org.flowable.validation.ValidationError;
import org.flowable.validation.validator.ProcessLevelValidator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MyFlowableValidator
extends ProcessLevelValidator {
    @Autowired
    private ProcessService processService;

    protected void executeValidation(BpmnModel bpmnModel, Process process, List<ValidationError> errors) {
        List endEventList;
        List startEventList = process.findFlowElementsOfType(StartEvent.class);
        if (CollectionUtils.isEmpty((Collection)startEventList)) {
            errors.add(this.validationErrorFactory(StartEvent.class.getName(), null, null, "\u8bf7\u8bbe\u7f6e\u5f00\u59cb\u8282\u70b9", true));
        }
        if (CollectionUtils.isEmpty((Collection)(endEventList = process.findFlowElementsOfType(EndEvent.class)))) {
            errors.add(this.validationErrorFactory(EndEvent.class.getName(), null, null, "\u8bf7\u8bbe\u7f6e\u7ed3\u675f\u8282\u70b9", true));
        }
    }

    private ValidationError validationErrorFactory(String elementType, String activityId, String activityName, String msg, boolean warning) {
        ValidationError validationError = new ValidationError();
        validationError.setActivityId(activityId);
        validationError.setActivityName(activityName);
        validationError.setDefaultDescription(msg);
        validationError.setWarning(warning);
        validationError.setProcessDefinitionName(elementType);
        return validationError;
    }
}

