package com.biz.cascore.shiro;

import java.util.Map;

import javax.annotation.Resource;

import org.apache.commons.lang.StringUtils;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.authz.SimpleAuthorizationInfo;
import org.apache.shiro.cas.CasRealm;
import org.apache.shiro.subject.PrincipalCollection;

import com.biz.cascore.api.service.AuthenticationApiService;
import com.biz.cascore.utils.WebApplicationContextUtils;
import com.biz.cascore.vo.PermissionContextVo;

public class AuthenticationRealmCenter extends CasRealm{
	

	@Resource(name="authenticationApiServiceImpl")
	private AuthenticationApiService authenticationApiService;

    /**
     * 获取授权信息
     * 
     * @param principals
     *            principals
     * @return 授权信息
     */
    @Override
    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principals) {
        SimpleAuthorizationInfo sai = (SimpleAuthorizationInfo) super.doGetAuthorizationInfo(principals);
        Integer adminId = null;
        if (!principals.isEmpty()) {
            for (Object principal : principals.asList()) {
                if (principal instanceof Map) {
                    adminId = Integer.valueOf((String)((Map<?, ?>) principal).get("id"));
                    break;
                }
            };
        }
        String appName = WebApplicationContextUtils.getInstance().getCurrentAppName();
        if (adminId != null) {
        	if(StringUtils.equals(appName, "main")) {
        		appName = null;
        	}
        	PermissionContextVo permissionContext = authenticationApiService.getPermissions(adminId, appName);
            sai.addStringPermissions(permissionContext.getPermissions());
            sai.addRoles(permissionContext.getRoles());
        }
        return sai;
    }

	/* (non-Javadoc)
	 * @param principals
	 * @see org.apache.shiro.realm.CachingRealm#onLogout(org.apache.shiro.subject.PrincipalCollection)
	 */
	@Override
	public void onLogout(PrincipalCollection principals) {
		super.onLogout(principals);
	}
	
	@Override
	protected void clearCache(PrincipalCollection principals) {
		System.out.println("AuthenticationRealmCenter.clearCache()");
		super.clearCache(principals);
	}
	@Override
	protected void clearCachedAuthenticationInfo(PrincipalCollection principals) {
		System.out.println("AuthenticationRealmCenter.clearCachedAuthenticationInfo()");
		super.clearCachedAuthenticationInfo(principals);
	}
	@Override
	protected void clearCachedAuthorizationInfo(PrincipalCollection principals) {
		System.out.println("AuthenticationRealmCenter.clearCachedAuthorizationInfo()");
		super.clearCachedAuthorizationInfo(principals);
	}
    
}
