/**
 * @Description: 
 * @ClassName: com.biz.omsadmin.shiro.HasPermission
 * @author: TRivers.chen(Administrator)
 * @date: 2016年6月20日 下午3:34:47 
 */
package com.biz.cascore.shiro;

import org.apache.shiro.web.tags.PermissionTag;

import com.biz.cascore.utils.WebApplicationContextUtils;

/**
 * 重写HasPermission 
 * 权限
 * @Description: 
 * @ClassName: com.biz.omsadmin.shiro.HasPermission
 * @author: TRivers.chen(Administrator)
 * @date: 2016年6月20日 下午3:34:47 
 *
 */
public class HasPermission extends PermissionTag{

	/**
	 * @Fields serialVersionUID : TODO
	 */
	private static final long serialVersionUID = 1L;
	

	/**
	 * 自定义权限控制
	 * @Title: showTagBody 
	 * @param p
	 * @return
	 * @author: TRivers.chen(Administrator)
	 * @date: 2016年6月20日 下午3:35:01
	 * @see org.apache.shiro.web.tags.PermissionTag#showTagBody(java.lang.String)
	 */
	@Override
	protected boolean showTagBody(String p) {
		String applicationName = WebApplicationContextUtils.getInstance().getCurrentAppName();
		p =applicationName.concat("-").concat(p);
        return isPermitted(p);
	}

}
