/**
 * @Description: 
 * @ClassName: com.biz.omsadmin.shiro.LacksPermission
 * @author: TRivers.chen(Administrator)
 * @date: 2016年6月20日 下午3:37:40 
 */
package com.biz.cascore.shiro;

import org.apache.shiro.web.tags.PermissionTag;

import com.biz.cascore.utils.WebApplicationContextUtils;

/**
 * 无指定权限判断
 * @Description: 
 * @ClassName: com.biz.omsadmin.shiro.LacksPermission
 * @author: TRivers.chen(Administrator)
 * @date: 2016年6月20日 下午3:37:40 
 *
 */
public class LacksPermission extends PermissionTag{

	/**
	 * @Fields serialVersionUID : TODO
	 */
	private static final long serialVersionUID = 1L;

	/**
	 * 无指定权限判断
	 * @Title: showTagBody 
	 * @param p
	 * @return
	 * @author: TRivers.chen(Administrator)
	 * @date: 2016年6月20日 下午3:37:49
	 * @see org.apache.shiro.web.tags.PermissionTag#showTagBody(java.lang.String)
	 */
	@Override
	protected boolean showTagBody(String p) {
		String applicationName = WebApplicationContextUtils.getInstance().getCurrentAppName();
		p = applicationName.concat("-").concat(p);
		return !isPermitted(p);
	}

}
