package com.biz.cascore.shiro;

import java.util.Arrays;
import java.util.List;

import org.apache.commons.lang.StringUtils;
import org.apache.shiro.authz.Permission;
import org.apache.shiro.authz.permission.WildcardPermission;

@SuppressWarnings("serial")
public class MyWildcardPermission extends WildcardPermission{

	
	 protected static final String MY_PERMISSION_TOKEN = "|";
	 protected String  wildcardString;
	 
	 public MyWildcardPermission(String permissionString) {
		 	super(permissionString);
			this.wildcardString = permissionString;
	}
	
	@Override
	public boolean implies(Permission p) {
		Boolean isFlag = super.implies(p);
		if(!isFlag) {
			if(!(p instanceof MyWildcardPermission)) {
				return false;
			}
			MyWildcardPermission myWildcardPermission = (MyWildcardPermission) p;
			return myImplies(myWildcardPermission);
		}
		return true;
	}
	
	@Override
	protected void setParts(String wildcardString, boolean caseSensitive) {
		this.wildcardString = wildcardString;
		super.setParts(wildcardString, caseSensitive);
	}
	
	protected boolean myImplies(MyWildcardPermission myWildcardPermission){
		try {
			//页面上获取的权限  如:(admin:member) (admin:member:save|update)
			String fromPagePermission = myWildcardPermission.wildcardString;
			//截取 角色拥有的权限 系统中存在如:(admin:member:save|update) 当为 (admin:member:*) 直接进super implies
			//否则  判断 截取之后: admin:member
			String fromSystemMainParts = StringUtils.substringBeforeLast(wildcardString, PART_DIVIDER_TOKEN);
			//判断是否有权限.(菜单初始)
			if (fromSystemMainParts.equalsIgnoreCase(fromPagePermission))  {
				return true;
			//当有部分的权限  判断 (admin:member:save|update) 之类 
			//首先判断是否为同一个角色 如果相同
			}else if (fromSystemMainParts.equalsIgnoreCase(StringUtils.substringBeforeLast(fromPagePermission, PART_DIVIDER_TOKEN))) {
				//截取系统中存在的角色权限 (admin:member:save|update) 截取之后: save|update
				String endRoleSystemParts = StringUtils.substringAfterLast(wildcardString, PART_DIVIDER_TOKEN);
				//转换成  操作权限集合 [save,update]
				List<String> endRoleSystemPartsList = Arrays.asList(StringUtils.split(endRoleSystemParts, MY_PERMISSION_TOKEN));
				//截取页面上获取的权限 判断是否拥有的权限 如:(admin:member:save) 截取: save
				String endfromPagePermission = StringUtils.substringAfterLast(fromPagePermission, PART_DIVIDER_TOKEN);
				//判断系统中当前角色下 是否包含 页面上的操作权限 
				if (endRoleSystemPartsList.contains(endfromPagePermission)) {
					return true;
				}
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
		return false;	
	}
}
