/*
 * Decompiled with CFR 0.152.
 */
package com.biz.commondocker.logging;

import com.biz.commondocker.exception.BusinessException;
import com.biz.commondocker.logging.LogstashLog;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Arrays;
import java.util.Objects;

/*
 * Exception performing whole class analysis ignored.
 */
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class LogstashLog {
    private final LogType type;
    private final String signature;
    @JsonIgnore
    private final Throwable ex;
    private final String traces;
    private final String exType;
    private final String exmsg;
    private final String args;
    private final String returnVal;
    private final Object logContent;
    @JsonIgnore
    private static final ObjectMapper mapper = new ObjectMapper();

    public static LogstashLog newEnterLog(Object ... args) {
        return new LogstashLog(LogType.enter, null, (Object)args, null, null);
    }

    public static LogstashLog newReturnsLog(Object returnVal) {
        return new LogstashLog(LogType.returns, null, null, returnVal, null);
    }

    public static LogstashLog newMethodLog(String signature, Object returnVal, Object ... args) {
        return new LogstashLog(signature, returnVal, null, args);
    }

    public static LogstashLog newMethodLog(String signature, Object returnVal, Throwable throwable, Object ... args) {
        return new LogstashLog(signature, returnVal, throwable, args);
    }

    public static LogstashLog newExLog(Throwable ex) {
        if (ex instanceof BusinessException) {
            return new LogstashLog(LogType.bizex, ex, null, null, null);
        }
        return new LogstashLog(LogType.ex, ex, null, null, null);
    }

    public static LogstashLog newExLog(Throwable ex, StackTraceElement trace) {
        if (ex instanceof BusinessException) {
            return new LogstashLog(LogType.bizex, ex, null, null, null, trace);
        }
        return new LogstashLog(LogType.ex, ex, null, null, null, trace);
    }

    public static LogstashLog newBizExLog(BusinessException ex) {
        return new LogstashLog(LogType.bizex, (Throwable)ex, null, null, null);
    }

    public static LogstashLog newProcessingLog(Object logContent) {
        return new LogstashLog(LogType.processing, null, null, null, logContent);
    }

    public static LogstashLog newLog(String signature, Object logContent) {
        return new LogstashLog(signature, logContent);
    }

    public static LogstashLog newLog(StackTraceElement ele, Object logContent) {
        String signatureString = ele.getClassName() + "." + ele.getMethodName() + "(..)#line=" + ele.getLineNumber();
        return new LogstashLog(signatureString, logContent);
    }

    private LogstashLog(String signature, Object returnVal, Throwable throwable, Object ... args) {
        this.signature = signature;
        this.logContent = null;
        this.type = throwable == null ? LogType.processing : LogType.ex;
        this.ex = throwable;
        this.exType = throwable == null ? null : throwable.getClass().toString();
        this.exmsg = throwable == null ? null : throwable.getMessage();
        this.args = Arrays.toString(args);
        this.returnVal = Objects.toString(returnVal, null);
        this.traces = null;
    }

    private LogstashLog(String signature, Object logContent) {
        this.signature = signature;
        this.logContent = logContent;
        this.type = LogType.processing;
        this.ex = null;
        this.exType = null;
        this.exmsg = null;
        this.args = null;
        this.returnVal = null;
        this.traces = null;
    }

    private LogstashLog(LogType type, Throwable ex, Object args, Object returnVal, Object logContent) {
        this(type, ex, args, returnVal, logContent, Thread.currentThread().getStackTrace()[3]);
    }

    private LogstashLog(LogType type, Throwable ex, Object args, Object returnVal, Object logContent, StackTraceElement trace) {
        StackTraceElement ele = trace;
        this.signature = ele.getClassName() + "." + ele.getMethodName() + "(..)#line=" + ele.getLineNumber();
        this.type = type;
        this.ex = ex;
        if (ex != null) {
            this.exmsg = ex.getMessage();
            this.exType = ex.getClass().getName();
            this.traces = ex instanceof BusinessException ? null : this.traceToString(ex.getStackTrace());
        } else {
            this.exType = null;
            this.exmsg = null;
            this.traces = null;
        }
        this.args = this.toString(args);
        this.returnVal = this.toString(returnVal);
        this.logContent = logContent;
    }

    public LogType getType() {
        return this.type;
    }

    public String getSignature() {
        return this.signature;
    }

    public Throwable getEx() {
        return this.ex;
    }

    public String getExmsg() {
        return this.exmsg;
    }

    public Object getArgs() {
        return this.args;
    }

    public Object getReturnVal() {
        return this.returnVal;
    }

    public Object getLogContent() {
        return this.logContent;
    }

    public String getExType() {
        return this.exType;
    }

    public String getTraces() {
        return this.traces;
    }

    public String toString() {
        try {
            return mapper.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            return "\u5e8f\u5217\u5316logstash log\u5bf9\u8c61\u5f02\u5e38:" + e.getMessage();
        }
    }

    private String toString(Object obj) {
        return obj == null ? null : obj.toString();
    }

    public static void main(String[] args) {
        System.out.println(LogstashLog.newExLog((Throwable)new Exception()));
    }

    private String traceToString(StackTraceElement[] traces) {
        StringBuilder builder = new StringBuilder();
        for (StackTraceElement t : traces) {
            builder.append(t.toString()).append("\r\n");
        }
        return builder.toString();
    }
}

