/*
 * Decompiled with CFR 0.152.
 */
package com.biz.commondocker.spring.event;

import com.biz.commondocker.asserts.SystemAsserts;
import com.biz.commondocker.spring.event.AbstractBizEventListener;
import com.biz.commondocker.spring.event.AbstractBizMultipleEventListener;
import com.biz.commondocker.spring.event.BizEvent;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.springframework.util.ReflectionUtils;

public abstract class AbstractBizMultipleEventListener
extends AbstractBizEventListener<BizEvent> {
    private Map<Class<?>, Method> eventHandlerMapping = new HashMap();

    @PostConstruct
    private void initMultiEventListener() {
        Method[] methods;
        this.logger.debug("\t\u6b63\u5728\u521d\u59cb\u5316\u591a\u4e8b\u4ef6\u76d1\u542c\u5668:");
        for (Method m : methods = this.getClass().getDeclaredMethods()) {
            EventHandler handler = m.getAnnotation(EventHandler.class);
            if (handler == null) continue;
            Object[] parameterTypes = m.getParameterTypes();
            SystemAsserts.notEmpty((Object[])parameterTypes, (String)"\u591a\u4e8b\u4ef6\u76d1\u542c\u5668\u7684\u5904\u7406\u65b9\u6cd5\u5fc5\u987b\u8981\u6709\u4e00\u4e2a\u53c2\u6570", (Object[])new Object[0]);
            Object clz = parameterTypes[0];
            SystemAsserts.isTrue((boolean)BizEvent.class.isAssignableFrom((Class<?>)clz), (String)"\u591a\u4e8b\u4ef6\u76d1\u542c\u5668\u7684\u5904\u7406\u65b9\u6cd5\u7b2c\u4e00\u4e2a\u53c2\u6570\u5fc5\u987b\u4e3aBizEvent\u6216\u5176\u5b50\u7c7b", (Object[])new Object[0]);
            if (this.eventHandlerMapping.containsKey(clz)) {
                SystemAsserts.isTrue((boolean)false, (String)"\u4e8b\u4ef6\u7c7b\u578b%s\u5728\u76d1\u542c\u5668%s\u4e2d\u7ed1\u5b9a\u4e86\u591a\u4e2a\u5904\u7406\u65b9\u6cd5:%s,%s", (Object[])new Object[]{((Class)clz).getName(), this.getClass().getName(), ((Method)this.eventHandlerMapping.get(clz)).getName(), m.getName()});
            }
            this.eventHandlerMapping.put(clz, m);
            this.logger.debug("\t\t\u76d1\u542c\u4e8b\u4ef6[{}]\u5728\u65b9\u6cd5[{}]", (Object)((Class)clz).getName(), (Object)m.getName());
        }
    }

    protected final void handleEvent(BizEvent event) {
        Method method = (Method)this.eventHandlerMapping.get(event.getClass());
        if (method != null) {
            this.logger.debug("\u4e8b\u4ef6{}\u5728\u76d1\u542c\u5668{}\u4e2d\u4e0a\u67e5\u627e\u5230\u6267\u884c\u65b9\u6cd5:{}", new Object[]{event.getClass().getSimpleName(), this.getClass().getSimpleName(), method.getName()});
            ReflectionUtils.makeAccessible((Method)method);
            ReflectionUtils.invokeMethod((Method)method, (Object)this, (Object[])new Object[]{event});
        }
    }
}

