/*
 * Decompiled with CFR 0.152.
 */
package com.biz.commondocker.spring.event;

import com.biz.commondocker.spring.event.BizEventMulticaster;
import com.biz.commondocker.spring.event.BizEventWrapper;
import com.biz.commondocker.spring.event.SyncBizEventWrapper;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.SimpleApplicationEventMulticaster;
import org.springframework.core.ResolvableType;
import org.springframework.util.Assert;
import org.springframework.util.ErrorHandler;

public class BizEventMulticaster
extends SimpleApplicationEventMulticaster {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public BizEventMulticaster() {
        this.setTaskExecutor((Executor)Executors.newSingleThreadExecutor());
        this.setErrorHandler((ErrorHandler)new EventLoggingErrorHandler());
    }

    public void multicastEvent(ApplicationEvent event) {
        this.multicastEvent(event, this.resolveDefaultEventType(event));
    }

    public void multicastEvent(ApplicationEvent event, ResolvableType eventType) {
        ResolvableType type;
        Executor executor = this.getTaskExecutor();
        boolean isAsyncEvent = this.isAsyncEvent(event);
        ApplicationEvent sourceEvent = this.findSourceEvent(event);
        ResolvableType resolvableType = type = eventType != null ? eventType : this.resolveDefaultEventType(sourceEvent);
        if (this.logger.isDebugEnabled()) {
            // empty if block
        }
        for (ApplicationListener listener : this.getApplicationListeners(sourceEvent, type)) {
            if (isAsyncEvent) {
                executor.execute((Runnable)new /* Unavailable Anonymous Inner Class!! */);
                continue;
            }
            this.invokeListener(listener, sourceEvent);
        }
    }

    private ApplicationEvent findSourceEvent(ApplicationEvent event) {
        return event instanceof BizEventWrapper ? ((BizEventWrapper)event).getEvent() : event;
    }

    protected boolean isAsyncEvent(ApplicationEvent event) {
        return !(event instanceof SyncBizEventWrapper);
    }

    private ResolvableType resolveDefaultEventType(ApplicationEvent event) {
        return ResolvableType.forInstance((Object)event);
    }

    protected Executor getTaskExecutor() {
        Executor executor = super.getTaskExecutor();
        Assert.notNull((Object)executor, (String)"multicaster's executor cannot be null");
        return executor;
    }

    static /* synthetic */ void access$000(BizEventMulticaster x0, ApplicationListener x1, ApplicationEvent x2) {
        x0.invokeListener(x1, x2);
    }
}

