/*
 * Decompiled with CFR 0.152.
 */
package com.biz.commondocker.spring.event;

import com.biz.commondocker.asserts.SystemAsserts;
import com.biz.commondocker.exception.SystemException;
import com.biz.commondocker.spring.event.AsyncBizEventWrapper;
import com.biz.commondocker.spring.event.BizEvent;
import com.biz.commondocker.spring.event.BizMqEvent;
import com.biz.commondocker.spring.event.BizMqEventPublisher;
import com.biz.commondocker.spring.event.SyncBizEventWrapper;
import com.biz.commondocker.spring.transaction.BizTransactionManager;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;

public class BizEventPublisher
implements ApplicationEventPublisherAware {
    private ApplicationEventPublisher applicationEventPublisher;
    private BizMqEventPublisher mqMessageEventPublisher;

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }

    public void publishEvent(BizEvent event) {
        SystemAsserts.notNull((Object)event, (String)"\u53d1\u5e03\u4e8b\u4ef6\u65f6\u4e8b\u4ef6\u5bf9\u8c61\u4e0d\u80fd\u4e3anull", (Object[])new Object[0]);
        AsyncBizEventWrapper eventWrapper = new AsyncBizEventWrapper(event);
        this.applicationEventPublisher.publishEvent((ApplicationEvent)eventWrapper);
        if (event instanceof BizMqEvent) {
            this.mqMessageEventPublisher.publishEvent((BizMqEvent)event);
        }
    }

    public void syncPublishEvent(BizEvent event) {
        SystemAsserts.notNull((Object)event, (String)"\u53d1\u5e03\u4e8b\u4ef6\u65f6\u4e8b\u4ef6\u5bf9\u8c61\u4e0d\u80fd\u4e3anull", (Object[])new Object[0]);
        SyncBizEventWrapper eventWrapper = new SyncBizEventWrapper(event);
        this.applicationEventPublisher.publishEvent((ApplicationEvent)eventWrapper);
    }

    public void publishEventUsingTransactionManager(BizEvent event) {
        SystemAsserts.notNull((Object)event, (String)"\u53d1\u5e03\u4e8b\u4ef6\u65f6\u4e8b\u4ef6\u5bf9\u8c61\u4e0d\u80fd\u4e3anull", (Object[])new Object[0]);
        try {
            BizTransactionManager.publishEvent((BizEvent)event, (boolean)true);
        }
        catch (SystemException e) {
            throw new UnsupportedOperationException("\u4f60\u53ef\u80fd\u6ca1\u6709\u4f7f\u7528BizTranactionManager\u6765\u4f5c\u4e3a\u4e8b\u52a1\u7ba1\u7406\u5668", e);
        }
    }

    public void syncPublishEventUsingTransactionManager(BizEvent event) {
        SystemAsserts.notNull((Object)event, (String)"\u53d1\u5e03\u4e8b\u4ef6\u65f6\u4e8b\u4ef6\u5bf9\u8c61\u4e0d\u80fd\u4e3anull", (Object[])new Object[0]);
        try {
            BizTransactionManager.publishEvent((BizEvent)event, (boolean)false);
        }
        catch (SystemException e) {
            throw new UnsupportedOperationException("\u4f60\u53ef\u80fd\u6ca1\u6709\u4f7f\u7528BizTranactionManager\u6765\u4f5c\u4e3a\u4e8b\u52a1\u7ba1\u7406\u5668", e);
        }
    }
}

