/*
 * Decompiled with CFR 0.152.
 */
package com.biz.commondocker.thdpool;

import com.biz.commondocker.thdpool.thdobj.CommonCallable;
import com.biz.commondocker.thdpool.thdobj.CommonFutureObj;
import com.biz.commondocker.thdpool.thdobj.CommonRunnable;
import com.biz.commondocker.thdpool.thdobj.ExecuteResult;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class PublicThreadPool {
    static final ExecutorService cachedThreadPool = Executors.newCachedThreadPool();
    static final ExecutorService singleThreadPool = Executors.newSingleThreadExecutor();
    static final ScheduledExecutorService scheduledThreadPool = Executors.newScheduledThreadPool(32);

    private PublicThreadPool() {
    }

    public static void scheduleExecute(Runnable runnable, long time, TimeUnit unit) {
        scheduledThreadPool.scheduleAtFixedRate(runnable, 0L, time, unit);
    }

    public static void scheduleExecute(CommonRunnable commonRunnable, long time, TimeUnit unit) {
        scheduledThreadPool.scheduleAtFixedRate((Runnable)commonRunnable, 0L, time, unit);
    }

    public static void execute(Runnable runnable) {
        cachedThreadPool.execute(runnable);
    }

    public static void execute(CommonRunnable commonRunnable) {
        cachedThreadPool.execute((Runnable)commonRunnable);
    }

    public static void singleExecute(Runnable runnable) {
        singleThreadPool.execute(runnable);
    }

    public static Future execute(Callable callable) throws Exception {
        return cachedThreadPool.submit(callable);
    }

    public static Future<CommonFutureObj> execute(CommonCallable commonCallable) throws Exception {
        return cachedThreadPool.submit(commonCallable);
    }

    public static Map<String, Object> getFutureExecuteResult(ArrayList<Future<CommonFutureObj>> getFutures) throws InterruptedException, ExecutionException {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        while (getFutures.size() > 0) {
            Iterator<Future<CommonFutureObj>> iter = getFutures.iterator();
            while (iter.hasNext()) {
                Future<CommonFutureObj> future = iter.next();
                if (!future.isDone()) continue;
                iter.remove();
                CommonFutureObj result = future.get();
                resultMap.put(result.getTarg(), result.getResultObj());
            }
        }
        return resultMap;
    }

    public static ExecuteResult checkFutureExecuteResult(ArrayList<Future<CommonFutureObj>> checkFutures) {
        while (checkFutures.size() > 0) {
            Iterator<Future<CommonFutureObj>> iter = checkFutures.iterator();
            while (iter.hasNext()) {
                Future<CommonFutureObj> future = iter.next();
                if (!future.isDone()) continue;
                iter.remove();
                try {
                    CommonFutureObj result = future.get();
                    if (result.getResult().booleanValue()) continue;
                    return ExecuteResult.error((String)result.getResultMsg(), (Object[])new Object[0]);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    return ExecuteResult.error((String)"\u7cfb\u7edf\u5f02\u5e38", (Object[])new Object[0]);
                }
                catch (ExecutionException e) {
                    e.printStackTrace();
                    return ExecuteResult.error((String)"\u7cfb\u7edf\u5f02\u5e38", (Object[])new Object[0]);
                }
            }
        }
        return ExecuteResult.success((String)"\u6267\u884c\u6210\u529f", (Object[])new Object[0]);
    }

    public static List<ExecuteResult> checkFutureExecuteAllResult(ArrayList<Future<CommonFutureObj>> checkFutures) throws InterruptedException, ExecutionException {
        ArrayList<ExecuteResult> msgs = new ArrayList<ExecuteResult>();
        while (checkFutures.size() > 0) {
            Iterator<Future<CommonFutureObj>> iter = checkFutures.iterator();
            while (iter.hasNext()) {
                Future<CommonFutureObj> future = iter.next();
                if (!future.isDone()) continue;
                iter.remove();
                CommonFutureObj result = future.get();
                if (!result.getResult().booleanValue()) {
                    msgs.add(ExecuteResult.error((String)result.getResultMsg(), (Object[])new Object[0]));
                    continue;
                }
                msgs.add(ExecuteResult.success((String)result.getResultMsg(), (Object[])new Object[0]));
            }
        }
        return msgs;
    }
}

