/*
 * Decompiled with CFR 0.152.
 */
package com.biz.commondocker.util;

import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class BaiDuLBSUtils {
    private static ResourceBundle resourceBundle = ResourceBundle.getBundle("LBS");
    private static final String LBS_SERVER_URL = "http://api.map.baidu.com/geocoder/v2/?address=";
    private static final String LBS_REVERSE_URL = "http://api.map.baidu.com/geocoder/v2/?location=";
    private static final String LBS_SHOW_METHOD = "json";
    private static final String PLACE_PATTERN = "((?=[\\x21-\\x7e\\uFE30-\\uFFA0]+)[^A-Za-z0-9])";

    public static void main(String[] args) {
        try {
            long starttime = System.currentTimeMillis();
            String str = "\u5e7f\u4e1c\u6c55\u5c3e\u5e02\u57ce\u533a\u9f99\u5bcc\u82b1\u56ed\u5e97";
            System.out.println(BaiDuLBSUtils.getProvinceSiteParse((String)str));
            System.out.println(System.currentTimeMillis() - starttime);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Map<String, String> getProvinceSiteParse(String lat, String lng) {
        return BaiDuLBSUtils.commonLatLngFindProvince((String)lat, (String)lng);
    }

    public static Map<String, String> getProvinceSiteParse(BigDecimal lat, BigDecimal lng) {
        return BaiDuLBSUtils.commonLatLngFindProvince((String)ObjectUtils.toString((Object)lat), (String)ObjectUtils.toString((Object)lng));
    }

    public static Map<String, String> getProvinceSiteParse(String address) {
        HashMap<String, String> provinceSite = new HashMap<String, String>();
        Map parseLatLng = BaiDuLBSUtils.getLngAndLatByAddress((String)address);
        if (MapUtils.isNotEmpty((Map)parseLatLng)) {
            return BaiDuLBSUtils.commonLatLngFindProvince((String)((BigDecimal)parseLatLng.get("lat")).toString(), (String)((BigDecimal)parseLatLng.get("lng")).toString());
        }
        return provinceSite;
    }

    private static Map<String, String> commonLatLngFindProvince(String lat, String lng) {
        HashMap<String, String> provinceSite = new HashMap<String, String>();
        if (StringUtils.isBlank((String)lat) || StringUtils.isBlank((String)lng)) {
            return provinceSite;
        }
        String str = BaiDuLBSUtils.parseProvinceSite((String)lat, (String)lng);
        if (StringUtils.isNotBlank((String)str)) {
            ObjectMapper objectMapper = new ObjectMapper();
            try {
                JsonNode jsonNode = objectMapper.readTree(str);
                JsonNode addressComponentNode = jsonNode.path("result").path("addressComponent");
                provinceSite.put("lat", lat);
                provinceSite.put("lng", lng);
                provinceSite.put("province", addressComponentNode.path("province").asText());
                provinceSite.put("city", addressComponentNode.path("city").asText());
                provinceSite.put("district", addressComponentNode.path("district").asText());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return provinceSite;
    }

    public static Map<String, BigDecimal> parse(String jsonStr) {
        Map<String, BigDecimal> location = null;
        try {
            Map object = (Map)JSONObject.parseObject((String)jsonStr, Map.class);
            Map result = (Map)object.get("result");
            if (result == null) {
                return new HashMap<String, BigDecimal>();
            }
            return (Map)result.get("location");
        }
        catch (Exception e) {
            e.printStackTrace();
            return location;
        }
    }

    public static Map<String, BigDecimal> getLngAndLatByAddress(String address) {
        try {
            address = StringUtils.deleteWhitespace((String)address);
            String json = BaiDuLBSUtils.parseSite((String)address);
            if (StringUtils.isNotBlank((String)json)) {
                return BaiDuLBSUtils.parse((String)json);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private static String parseProvinceSite(String lat, String lng) {
        try {
            String latLng = String.format("%s,%s", lat, lng);
            URL url = new URL("http://api.map.baidu.com/geocoder/v2/?location=" + latLng + "&output=" + "json" + "&ak=" + resourceBundle.getString("LBS_AK"));
            return BaiDuLBSUtils.returnRespVal((URL)url);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static String parseSite(String key) {
        String tempAddress = key = key.replaceAll("((?=[\\x21-\\x7e\\uFE30-\\uFFA0]+)[^A-Za-z0-9])", "");
        int len = 0;
        for (int i = 0; i < key.length(); ++i) {
            int currentLent = String.valueOf(key.charAt(i)).getBytes().length;
            if (len + currentLent <= 100) {
                len += currentLent;
                continue;
            }
            tempAddress = key.substring(0, i);
            break;
        }
        try {
            tempAddress = URLEncoder.encode(tempAddress, "utf-8");
            URL url = new URL("http://api.map.baidu.com/geocoder/v2/?address=" + tempAddress + "&output=" + "json" + "&ak=" + resourceBundle.getString("LBS_AK"));
            return BaiDuLBSUtils.returnRespVal((URL)url);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String returnRespVal(URL url) throws Exception {
        StringBuilder sb;
        block8: {
            HttpURLConnection connection = null;
            InputStream is = null;
            InputStreamReader streamReader = null;
            BufferedReader reader = null;
            sb = new StringBuilder();
            try {
                connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod("GET");
                connection.setRequestProperty("Content-Type", "text/html;charset=utf-8");
                connection.connect();
                is = connection.getInputStream();
                streamReader = new InputStreamReader(is);
                reader = new BufferedReader(streamReader);
                String str = null;
                while ((str = reader.readLine()) != null) {
                    sb.append(str);
                }
                IOUtils.closeQuietly((Reader)reader);
            }
            catch (Exception e) {
                e.printStackTrace();
                break block8;
            }
            finally {
                IOUtils.closeQuietly(reader);
                IOUtils.closeQuietly(streamReader);
                IOUtils.closeQuietly(is);
                if (connection != null) {
                    connection.disconnect();
                }
            }
            IOUtils.closeQuietly((Reader)streamReader);
            IOUtils.closeQuietly((InputStream)is);
            if (connection != null) {
                connection.disconnect();
            }
        }
        return sb.toString();
    }
}

