/*
 * Decompiled with CFR 0.152.
 */
package com.biz.commondocker.util;

import com.biz.commondocker.enums.DateTypeEnum;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Random;
import org.apache.commons.lang3.StringUtils;
import org.codelogger.utils.DateUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public final class DateUtil {
    public static final long SECOND = 1000L;
    public static final long MINUTE = 60000L;
    public static final long HOUR = 3600000L;
    public static final long TWOHOUR = 0x6DDD00L;
    public static final long DAY = 86400000L;
    public static final long DAY3 = 259200000L;
    public static final long DAY7 = 604800000L;
    public static final long DAY15 = 1296000000L;
    public static final long DAY30 = 2592000000L;
    public static final DateFormat SQL99_TIME_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.S");
    public static final DateFormat DATE_NUMBER_FORMAT = new SimpleDateFormat("yyyyMMdd");

    private DateUtil() {
    }

    public static Timestamp now() {
        return new Timestamp(System.currentTimeMillis());
    }

    public static String durationFormat(long duration) {
        if (duration >= 86400000L) {
            return duration / 86400000L + "\u5929";
        }
        if (duration >= 3600000L) {
            return duration / 3600000L + "\u5c0f\u65f6";
        }
        if (duration >= 60000L) {
            return duration / 60000L + "\u5206\u949f";
        }
        return duration / 1000L + "\u79d2";
    }

    public static Date today() {
        return new Date(System.currentTimeMillis());
    }

    public static int betweenDays(Date from, Date to) {
        long duration = to.getTime() - from.getTime();
        return (int)(duration / 86400000L + (long)(duration % 86400000L == 0L ? 0 : 1));
    }

    public static Date weekAgo() {
        Calendar c = Calendar.getInstance();
        c.add(5, -7);
        return new Date(c.getTimeInMillis());
    }

    public static long beforeDays(int days) {
        days = days < 0 ? days : -days;
        Calendar c = Calendar.getInstance();
        c.add(5, days);
        return c.getTimeInMillis();
    }

    public static long afterDays(int days) {
        Calendar c = Calendar.getInstance();
        c.add(5, days);
        return c.getTimeInMillis();
    }

    public static int getWeek1to7(long timeMillis) {
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(timeMillis);
        int week = c.get(7);
        if (week == 1) {
            return 7;
        }
        return week - 1;
    }

    public static String getWeekName(int week) {
        switch (week) {
            case 1: {
                return "\u5468\u4e00";
            }
            case 2: {
                return "\u5468\u4e8c";
            }
            case 3: {
                return "\u5468\u4e09";
            }
            case 4: {
                return "\u5468\u56db";
            }
            case 5: {
                return "\u5468\u4e94";
            }
            case 6: {
                return "\u5468\u516d";
            }
            case 7: {
                return "\u5468\u65e5";
            }
        }
        return "";
    }

    public static int getTimeInMinute(long timeMillis) {
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(timeMillis);
        return c.get(11) * 60 + c.get(12);
    }

    public static int getTime(long ts, int calendarType) {
        Calendar calDate = Calendar.getInstance();
        calDate.setTime(new Date(ts));
        return calDate.get(calendarType);
    }

    public static String formatTo24Hour(int minute) {
        if (minute <= 0) {
            return "00:00";
        }
        if (minute >= 1440) {
            return "24:00";
        }
        return DateUtil.prefixDecade((int)(minute / 60)) + ":" + DateUtil.prefixDecade((int)(minute % 60));
    }

    private static String prefixDecade(int num) {
        return num >= 10 ? "" + num : "0" + num;
    }

    public static String getMinuteItBPay(Long limitTime) {
        Calendar calendar = Calendar.getInstance();
        Long nowTime = calendar.getTimeInMillis();
        Long betweenMinute = (limitTime - nowTime) / 1000L / 60L;
        return betweenMinute + "m";
    }

    public static String getNowDate() {
        return DateUtils.getDateFormat((Date)new Date(), (String)"yyyyMMdd");
    }

    public static String getNowFmtDatetime(String fmt) {
        return DateUtils.getDateFormat((Date)new Date(), (String)fmt);
    }

    public static Long getTime(String fmtDateStr) {
        return DateUtils.getDateFromString((String)fmtDateStr).getTime();
    }

    public static boolean isToday(Long currentTime) {
        return StringUtils.equals((CharSequence)new Date(System.currentTimeMillis()).toString(), (CharSequence)new Date(currentTime).toString());
    }

    public static boolean isMonth(Long currentTime) {
        GregorianCalendar min = new GregorianCalendar();
        ((Calendar)min).add(5, -30);
        return currentTime >= min.getTimeInMillis();
    }

    public static Long getTodayStartTime() {
        Calendar todayStart = Calendar.getInstance();
        todayStart.set(11, 0);
        todayStart.set(12, 0);
        todayStart.set(13, 0);
        todayStart.set(14, 0);
        return todayStart.getTime().getTime();
    }

    public static Long getTodayEndTime() {
        Calendar todayEnd = Calendar.getInstance();
        todayEnd.set(11, 23);
        todayEnd.set(12, 59);
        todayEnd.set(13, 59);
        todayEnd.set(14, 999);
        return todayEnd.getTime().getTime();
    }

    public static Long getYesterdayStartTime() {
        Calendar calendar = Calendar.getInstance();
        Date now = new Date();
        calendar.set(5, now.getDate() - 1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime().getTime();
    }

    public static Long getYesterdayEndTime() {
        Calendar calendar = Calendar.getInstance();
        Date now = new Date();
        calendar.set(5, now.getDate() - 1);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
        return calendar.getTime().getTime();
    }

    public static Long getPresentMonthStartTime() {
        Calendar monthStart = Calendar.getInstance();
        monthStart.set(5, 1);
        monthStart.set(11, 0);
        monthStart.set(12, 0);
        monthStart.set(13, 0);
        monthStart.set(14, 0);
        return monthStart.getTime().getTime();
    }

    public static Long getOneHourAgoTime() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(11, calendar.get(11) - 1);
        return calendar.getTime().getTime();
    }

    public static String longToDateStr(long time, String fmtDateStr) {
        SimpleDateFormat s = new SimpleDateFormat(fmtDateStr);
        String dateStr = s.format(new Date(time));
        return dateStr;
    }

    public static String formatChars(long time) {
        return DateUtil.longToDateStr((long)time, (String)"yyyy-MM-dd HH:mm:ss");
    }

    public static int getAfterSeconds(Long futureTime) {
        if (futureTime == null) {
            return 0;
        }
        int durationSeconds = (int)((futureTime - System.currentTimeMillis()) / 1000L);
        return durationSeconds >= 0 ? durationSeconds : 0;
    }

    public static int hourToMinutes(String hourOfDay) {
        if (StringUtils.isBlank((CharSequence)hourOfDay)) {
            return 0;
        }
        int hour = Integer.valueOf(StringUtils.substringBefore((String)hourOfDay, (String)":"));
        int minute = Integer.valueOf(StringUtils.substringAfter((String)hourOfDay, (String)":"));
        return hour * 60 + minute;
    }

    public static Long getAgeTime(Integer age) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(11, 0);
        calendar.set(13, 0);
        calendar.set(12, 0);
        calendar.set(14, 0);
        calendar.add(1, -age.intValue());
        return calendar.getTime().getTime();
    }

    public static Long getAccountPayTime(Integer minute) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(12, -minute.intValue());
        return calendar.getTime().getTime();
    }

    public static Date getTargetTime(Time time) {
        Calendar c = Calendar.getInstance();
        c.set(11, time.getHours());
        c.set(12, time.getMinutes());
        c.set(13, time.getSeconds());
        return c.getTime();
    }

    public static boolean isTimesIntersection(Date start1, Date end1, Date start2, Date end2) {
        long start1l = start1.getTime();
        long end1l = end1.getTime();
        long start2l = start2.getTime();
        long end2l = end2.getTime();
        return end1l >= start2l && start1l <= end2l;
    }

    public static boolean isDateBetween(Date compare, Date start, Date end) {
        if (compare == null || start == null || end == null) {
            return false;
        }
        long cl = compare.getTime();
        long sl = start.getTime();
        long el = end.getTime();
        return cl >= sl && cl <= el;
    }

    public static boolean isNowBetween(Date start, Date end) {
        return DateUtil.isDateBetween((Date)new Date(), (Date)start, (Date)end);
    }

    public static boolean isAfter(Date date) {
        return date != null && System.currentTimeMillis() >= date.getTime();
    }

    public static boolean isBefore(Date date) {
        return date != null && System.currentTimeMillis() < date.getTime();
    }

    public static String getTodayBeginTimeWithSql99Format() {
        return SQL99_TIME_FORMAT.format(new Date(DateUtil.getTodayStartTime()));
    }

    public static String getTodayEndTimeWithSql99Format() {
        return SQL99_TIME_FORMAT.format(new Date(DateUtil.getTodayEndTime()));
    }

    public static String getPresentMonthStartTimeWithSql99Format() {
        return SQL99_TIME_FORMAT.format(new Date(DateUtil.getPresentMonthStartTime()));
    }

    public static String getYesterDayBeiginTimeWithSql99Format() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date(DateUtil.getTodayStartTime()));
        calendar.add(5, -1);
        return SQL99_TIME_FORMAT.format(calendar.getTime());
    }

    public static String getYesterDayEndTimeWithSql99Format() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date(DateUtil.getTodayEndTime()));
        calendar.add(5, -1);
        return SQL99_TIME_FORMAT.format(calendar.getTime());
    }

    public static String getLastDateWithFormat(DateFormat df) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -1);
        return df.format(calendar.getTime());
    }

    public static String getLastDateWithNumberFormat() {
        return DateUtil.getLastDateWithFormat((DateFormat)DATE_NUMBER_FORMAT);
    }

    public static Timestamp newTimestamp(String fmtDateStr) {
        return new Timestamp(DateUtil.getTime((String)fmtDateStr));
    }

    public static Timestamp getTimestamp(String dateStr) {
        if (StringUtils.isNotBlank((CharSequence)dateStr) && dateStr.matches("\\d{4}-\\d{1,2}-\\d{1,2}")) {
            return DateUtil.getTimestamp((String)dateStr, (String)"yyyy-MM-dd");
        }
        return DateUtil.getTimestamp((String)dateStr, (String)"yyyy-MM-dd HH:mm:ss");
    }

    public static Timestamp getTimestamp(String dateStr, String dateFmt) {
        Timestamp timestamp = null;
        SimpleDateFormat f = new SimpleDateFormat(dateFmt);
        try {
            timestamp = new Timestamp(f.parse(dateStr).getTime());
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return timestamp;
    }

    public static boolean isNowInTimeRange(Time start, Time end) {
        assert (start != null && end != null);
        Date now = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(start);
        calendar.set(10, now.getHours());
        calendar.set(12, now.getMinutes());
        calendar.set(13, now.getSeconds());
        Time nowTime = new Time(calendar.getTime().getTime());
        return nowTime.before(end) && nowTime.after(start);
    }

    public static String getYesterdatStartTimeWithSql99Format() {
        return SQL99_TIME_FORMAT.format(new Date(DateUtil.getYesterdayStartTime()));
    }

    public static String getYesterdatEndTimeWithSql99Format() {
        return SQL99_TIME_FORMAT.format(new Date(DateUtil.getYesterdayEndTime()));
    }

    public static Timestamp getYesterdayRandomTime() {
        Random random = new Random();
        Calendar calendar = Calendar.getInstance();
        Date now = new Date();
        calendar.set(5, now.getDate() - 1);
        long timeMillis = calendar.getTime().getTime();
        return new Timestamp(timeMillis + (long)random.nextInt(100000000));
    }

    public static String getWeek(String s, String ptn) {
        SimpleDateFormat sdf = new SimpleDateFormat(ptn);
        Date date = null;
        try {
            date = sdf.parse(s);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        Calendar c = Calendar.getInstance();
        try {
            c.setTime(date);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        int dayForWeek = 0;
        dayForWeek = c.get(7) == 1 ? 7 : c.get(7) - 1;
        return DateUtil.getWeekName((int)dayForWeek);
    }

    public static String endDayHoursMinutes(Timestamp endTimestamp) {
        long between = endTimestamp.getTime() - DateUtil.now().getTime();
        long day = between / (long)DateTypeEnum.DAY.toValue().intValue();
        long hour = between / (long)DateTypeEnum.HOUR.toValue().intValue() - day * 24L;
        long min = between / (long)DateTypeEnum.MINUTE.toValue().intValue() - day * 24L * 60L - hour * 60L;
        long s = between / (long)DateTypeEnum.SECOND.toValue().intValue() - day * 24L * 60L * 60L - hour * 60L * 60L - min * 60L;
        if (day <= 0L && hour <= 0L && min <= 0L && s <= 0L) {
            return 0 + DateTypeEnum.HOUR.getTitle() + 0 + DateTypeEnum.MINUTE.getTitle() + 0 + DateTypeEnum.SECOND.getTitle();
        }
        if (day > 0L) {
            return day + DateTypeEnum.DAY.getTitle() + hour + DateTypeEnum.HOUR.getTitle() + min + DateTypeEnum.MINUTE.getTitle() + s + DateTypeEnum.SECOND.getTitle();
        }
        return hour + DateTypeEnum.HOUR.getTitle() + min + DateTypeEnum.MINUTE.getTitle() + s + DateTypeEnum.SECOND.getTitle();
    }

    public static Long endtimeMillisecond(Timestamp endTimestamp) {
        long between = endTimestamp.getTime() - DateUtil.now().getTime();
        return between < 0L ? 0L : between;
    }

    public static String beginDayHoursMinutes(Timestamp beginTimestamp) {
        long between = beginTimestamp.getTime() - DateUtil.now().getTime();
        long day = between / (long)DateTypeEnum.DAY.toValue().intValue();
        long hour = between / (long)DateTypeEnum.HOUR.toValue().intValue() - day * 24L;
        long min = between / (long)DateTypeEnum.MINUTE.toValue().intValue() - day * 24L * 60L - hour * 60L;
        long s = between / (long)DateTypeEnum.SECOND.toValue().intValue() - day * 24L * 60L * 60L - hour * 60L * 60L - min * 60L;
        if (day <= 0L && hour <= 0L && min <= 0L && s <= 0L) {
            return 0 + DateTypeEnum.HOUR.getTitle() + 0 + DateTypeEnum.MINUTE.getTitle() + 0 + DateTypeEnum.SECOND.getTitle();
        }
        if (day > 0L) {
            return day + DateTypeEnum.DAY.getTitle() + hour + DateTypeEnum.HOUR.getTitle() + min + DateTypeEnum.MINUTE.getTitle() + s + DateTypeEnum.SECOND.getTitle();
        }
        return hour + DateTypeEnum.HOUR.getTitle() + min + DateTypeEnum.MINUTE.getTitle() + s + DateTypeEnum.SECOND.getTitle();
    }

    public static Long begintimeMillisecond(Timestamp beginTimestamp) {
        long between = beginTimestamp.getTime() - DateUtil.now().getTime();
        return between < 0L ? 0L : between;
    }
}

