/*
 * Decompiled with CFR 0.152.
 */
package com.biz.commondocker.util;

import com.biz.commondocker.util.DateUtils;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.concurrent.TimeUnit;
import org.joda.time.DateTime;
import org.joda.time.Days;
import org.joda.time.Interval;
import org.joda.time.LocalDate;
import org.joda.time.Months;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

/*
 * Exception performing whole class analysis ignored.
 */
public class DateUtils {
    private static final Integer YEAR_MONTH_COUNT = 12;

    public static long timeBetween(Date date1, Date date2, TimeUnit timeUnit) {
        long millisBetween = date1.compareTo(date2) > 0 ? date1.getTime() - date2.getTime() : date2.getTime() - date1.getTime();
        switch (1.$SwitchMap$java$util$concurrent$TimeUnit[timeUnit.ordinal()]) {
            case 1: {
                return millisBetween / 1000L;
            }
            case 2: {
                return millisBetween / 1000L / 60L;
            }
            case 3: {
                return millisBetween / 1000L / 60L / 60L;
            }
            case 4: {
                return millisBetween / 1000L / 60L / 60L / 24L;
            }
        }
        return millisBetween;
    }

    public static Date yesterday() {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(new Date());
        calendar.clear(11);
        calendar.clear(12);
        calendar.clear(13);
        calendar.clear(14);
        calendar.add(6, -1);
        Date date = calendar.getTime();
        return org.apache.commons.lang.time.DateUtils.setHours((Date)date, (int)0);
    }

    public static Date yesterday(Date now) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(now);
        calendar.add(6, -1);
        return calendar.getTime();
    }

    public static int daysBetween(Date date, Date date2) {
        Interval interval = new Interval((ReadableInstant)new DateTime((Object)date), (ReadableInstant)new DateTime((Object)date2));
        return DateUtils.getCountOfMidnights((Interval)interval);
    }

    private static int getCountOfMidnights(Interval interval) {
        LocalDate start = interval.getStart().toLocalDate();
        LocalDate end = interval.getEnd().toLocalDate();
        int countOfMidnights = Days.daysBetween((ReadablePartial)start, (ReadablePartial)end).getDays();
        return countOfMidnights;
    }

    public static Date today() {
        Date date = new Date();
        date = org.apache.commons.lang.time.DateUtils.setHours((Date)date, (int)0);
        date = org.apache.commons.lang.time.DateUtils.setMinutes((Date)date, (int)0);
        date = org.apache.commons.lang.time.DateUtils.setSeconds((Date)date, (int)0);
        date = org.apache.commons.lang.time.DateUtils.setMilliseconds((Date)date, (int)0);
        return date;
    }

    public static Date addSeconds(Date date, Integer secondCount) {
        DateTime dateTime = new DateTime((Object)date);
        dateTime = dateTime.plusSeconds(secondCount.intValue());
        return dateTime.toDate();
    }

    public static Date addMinutes(Date date, Integer minuteCount) {
        DateTime dateTime = new DateTime((Object)date);
        dateTime = dateTime.plusMinutes(minuteCount.intValue());
        return dateTime.toDate();
    }

    public static Date addHours(Date date, Integer hoursCount) {
        DateTime dateTime = new DateTime((Object)date);
        dateTime = dateTime.plusHours(hoursCount.intValue());
        return dateTime.toDate();
    }

    public static Date addDay(Date date, Integer dayCount) {
        DateTime dateTime = new DateTime((Object)date);
        dateTime = dateTime.plusDays(dayCount.intValue());
        return dateTime.toDate();
    }

    public static Date addMonth(Date date, Integer monthCount) {
        DateTime dateTime = new DateTime((Object)date);
        dateTime = dateTime.plusMonths(monthCount.intValue());
        return dateTime.toDate();
    }

    public static Date addYear(Date date, Integer yearCount) {
        DateTime dateTime = new DateTime((Object)date);
        dateTime = dateTime.plusYears(yearCount.intValue());
        return dateTime.toDate();
    }

    public static int MonthBetween(Date startDate, Date endDate) {
        Interval interval = new Interval((ReadableInstant)new DateTime((Object)startDate), (ReadableInstant)new DateTime((Object)endDate));
        LocalDate start = interval.getStart().toLocalDate();
        LocalDate end = interval.getEnd().toLocalDate();
        return Months.monthsBetween((ReadablePartial)start, (ReadablePartial)end).getMonths();
    }

    public static Boolean isExistsBetweenDate(Date startDate, Date endDate, Date currentDate) {
        Boolean isFlag = false;
        DateTime currentDateTime = new DateTime((Object)currentDate);
        if (startDate != null) {
            DateTime startDateTime = new DateTime((Object)startDate);
            if (startDateTime.compareTo((ReadableInstant)currentDateTime) <= 0) {
                isFlag = true;
            } else {
                return false;
            }
        }
        if (endDate != null) {
            DateTime endDateTime = new DateTime((Object)endDate);
            if (endDateTime.compareTo((ReadableInstant)currentDateTime) >= 0) {
                isFlag = true;
            } else {
                return false;
            }
        }
        return isFlag;
    }

    public static Integer getHasMonths(Date startDate) {
        if (startDate == null) {
            return 0;
        }
        DateTime dateTime = new DateTime((Object)startDate);
        Integer currentMoth = dateTime.getMonthOfYear();
        Integer totalMonth = dateTime.getYear() * YEAR_MONTH_COUNT + currentMoth;
        return totalMonth;
    }

    public static Integer getHourse(Date startDate) {
        if (startDate == null) {
            return null;
        }
        DateTime dateTime = new DateTime((Object)startDate);
        return dateTime.getHourOfDay();
    }

    public static String getYYYYMMDD() {
        return DateUtils.getTimeByPattern((String)"yyyy-MM-dd");
    }

    public static String getYYYYMMDDHHMMSS() {
        return DateUtils.getTimeByPattern((String)"yyyyMMddHHmmss");
    }

    public static String getTimeByPattern(String pattern) {
        return DateUtils.getTimeByPattern((Date)new Date(), (String)pattern);
    }

    public static String getTimeByPattern(Date date, String pattern) {
        DateTimeFormatter dateTimeFormatter = DateTimeFormat.forPattern((String)pattern);
        return dateTimeFormatter.print((ReadableInstant)new DateTime((Object)date));
    }

    public static String getYesterDay(String pattern) {
        DateTime dateTime = DateTime.now();
        return DateUtils.getPrevDay((Date)dateTime.toDate(), (String)pattern);
    }

    public static String getPrevDay(Date date, String pattern) {
        DateTime dateTime = new DateTime((Object)date);
        dateTime = dateTime.plusDays(-1);
        DateTimeFormatter fmt = DateTimeFormat.forPattern((String)pattern);
        return fmt.print((ReadableInstant)dateTime);
    }

    public static Date stringParseDate(String dateJson, String pattern) {
        DateTimeFormatter formatter = DateTimeFormat.forPattern((String)pattern);
        DateTime dateTime = formatter.parseDateTime(dateJson);
        return dateTime.toDate();
    }

    public static String dateToString(Date date, String pattern) {
        DateTimeFormatter formatter = DateTimeFormat.forPattern((String)pattern);
        return formatter.print(date.getTime());
    }
}

