/*
 * Decompiled with CFR 0.152.
 */
package com.biz.commondocker.util;

/*
 * Exception performing whole class analysis ignored.
 */
public class DistanceCalc {
    private static double PI = Math.PI;
    private static double TWOPI = Math.PI * 2;
    private static double DE2RA = 0.01745329252;
    private static double RA2DE = 57.2957795129;
    private static double ERAD = 6378.135;
    private static double ERADM = 6378135.0;
    private static double AVG_ERAD = 6371.0;
    private static double FLATTENING = 0.0033528106647474805;
    private static double EPS = 5.0E-12;
    private static double KM2MI = 0.621371;
    private static double GEOSTATIONARY_ALT = 35786.0;

    public static double distance(double lat1, double lon1, double lat2, double lon2) {
        double H2;
        double R;
        double H1;
        lat1 = DE2RA * lat1;
        lon1 = -DE2RA * lon1;
        lat2 = DE2RA * lat2;
        lon2 = -DE2RA * lon2;
        double F = (lat1 + lat2) / 2.0;
        double G = (lat1 - lat2) / 2.0;
        double L = (lon1 - lon2) / 2.0;
        double sing = Math.sin(G);
        double cosl = Math.cos(L);
        double cosf = Math.cos(F);
        double sinl = Math.sin(L);
        double sinf = Math.sin(F);
        double cosg = Math.cos(G);
        double S = sing * sing * cosl * cosl + cosf * cosf * sinl * sinl;
        double C = cosg * cosg * cosl * cosl + sinf * sinf * sinl * sinl;
        double W = Math.atan2(Math.sqrt(S), Math.sqrt(C));
        double D = 2.0 * W * ERAD;
        double result = D * (1.0 + FLATTENING * (H1 = (3.0 * (R = Math.sqrt(S * C) / W) - 1.0) / (2.0 * C)) * sinf * sinf * cosg * cosg - FLATTENING * (H2 = (3.0 * R + 1.0) / (2.0 * S)) * cosf * cosf * sing * sing) * 1000.0;
        return Double.isNaN(result) ? 0.0 : result;
    }

    public static void main(String[] args) {
        double val = DistanceCalc.distance((double)32.234233, (double)104.06201405, (double)32.234233, (double)104.06201405);
        System.out.println(val);
        System.out.println(Double.isNaN(val));
    }
}

