/*
 * Decompiled with CFR 0.152.
 */
package com.biz.commondocker.util;

public final class GeneratorCodeUtils {
    private final long twepoch = 1361753741828L;
    private final long workerIdBits = 5L;
    private final long datacenterIdBits = 10L;
    private final long maxWorkerId = 31L;
    private final long maxDatacenterId = 1023L;
    private final long sequenceBits = 4L;
    private final long workerIdShift = 4L;
    private final long datacenterIdShift = 9L;
    private final long timestampLeftShift = 19L;
    private final long sequenceMask = 15L;
    private static GeneratorCodeUtils instance = null;
    private long workerId;
    private long datacenterId;
    private long sequence = 0L;
    private long lastTimestamp = -1L;

    private GeneratorCodeUtils() {
    }

    public static synchronized GeneratorCodeUtils instance() {
        if (instance == null) {
            instance = new GeneratorCodeUtils();
        }
        return instance;
    }

    private GeneratorCodeUtils(int markCode, int projectMarkCode) {
        if (this.workerId > 31L || this.workerId < 0L) {
            throw new IllegalArgumentException(String.format("worker Id can't be greater than %d or less than 0", 31L));
        }
        if (this.datacenterId > 1023L || this.datacenterId < 0L) {
            throw new IllegalArgumentException(String.format("datacenter Id can't be greater than %d or less than 0", 1023L));
        }
        this.workerId = markCode;
        this.datacenterId = projectMarkCode;
    }

    public synchronized long nextId() {
        long timestamp = this.timeGen();
        if (timestamp < this.lastTimestamp) {
            throw new RuntimeException(String.format("Clock moved backwards.  Refusing to generate id for %d milliseconds", this.lastTimestamp - timestamp));
        }
        if (this.lastTimestamp == timestamp) {
            this.sequence = this.sequence + 1L & 0xFL;
            if (this.sequence == 0L) {
                timestamp = this.tilNextMillis(this.lastTimestamp);
            }
        } else {
            this.sequence = 0L;
        }
        this.lastTimestamp = timestamp;
        long nextId = this.workerId << 4 | this.sequence | this.datacenterId << 9 | timestamp - 1361753741828L << 19;
        return nextId;
    }

    protected long tilNextMillis(long lastTimestamp) {
        long timestamp = this.timeGen();
        while (timestamp <= lastTimestamp) {
            timestamp = this.timeGen();
        }
        return timestamp;
    }

    protected long timeGen() {
        return System.currentTimeMillis();
    }

    public synchronized String code(int markCode, int projectMarkCode) {
        if (instance != null) {
            this.workerId = markCode;
            this.datacenterId = projectMarkCode;
        }
        return String.valueOf(instance.nextId());
    }
}

