/*
 * Decompiled with CFR 0.152.
 */
package com.biz.commondocker.util;

import com.alibaba.fastjson.JSONObject;
import com.biz.commondocker.util.GZIPRequestInterceptor;
import com.biz.commondocker.util.GZIPResponseInterceptor;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.ConnectionPoolTimeoutException;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContexts;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class HttpClientUtil {
    protected static final Logger logger = LoggerFactory.getLogger(HttpClientUtil.class);
    private static PoolingHttpClientConnectionManager connectionManager;
    public static CloseableHttpClient httpclient;
    private static Logger log;
    public static final int MAX_TOTAL_CONNECTIONS = 800;
    public static final int WAIT_TIMEOUT = 60000;
    private static final int MAX_ROUTE_CONNECTIONS = 250;
    private static final int CONNECT_TIMEOUT = 30000;
    public static final int READ_TIMEOUT = 30000;
    private static final int BUFFER_SIZE = 4096;
    private static final int SO_TIMEOUT = 60000;
    private static final int DEFAULT_RETRY_TIME = 3;
    private static final String CHARSET = "UTF-8";
    private static SSLConnectionSocketFactory sslsf;
    private static SSLContext sslcontext;
    private static HttpRequestRetryHandler requestRetryHandler;

    public static void printHeader(HttpResponse response) {
        Header[] headers = response.getAllHeaders();
        StringBuilder cookie = new StringBuilder();
        for (int ii = 0; ii < headers.length; ++ii) {
            System.out.println(headers[ii].getName() + ": " + headers[ii].getValue());
            if (!StringUtils.endsWithIgnoreCase((String)headers[ii].getName(), (String)"Set-Cookie")) continue;
            cookie.append(headers[ii].getValue()).append(";");
        }
        System.out.println(cookie.toString());
    }

    public static String doPost(String url, JSONObject jsonObject) throws Exception {
        HashMap map = new HashMap();
        try {
            for (Map.Entry entry : jsonObject.entrySet()) {
                if (entry.getKey() == null || entry.getValue() == null) continue;
                map.put(entry.getKey(), entry.getValue());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return HttpClientUtil.doPost((String)url, map);
    }

    public static String doPost(String url, Map<String, Object> map) throws Exception {
        logger.debug("HttpClientUtil doPost  url:{},param:{}", (Object)url, map);
        HttpClientContext context = HttpClientContext.create();
        HttpPost httpPost = new HttpPost(url);
        RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout(30000).setConnectTimeout(30000).setSocketTimeout(30000).build();
        httpPost.setConfig(requestConfig);
        CloseableHttpResponse response = null;
        try {
            ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                params.add(new BasicNameValuePair(entry.getKey(), entry.getValue().toString()));
            }
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(params, "UTF-8"));
            response = httpclient.execute((HttpUriRequest)httpPost, (HttpContext)context);
            HttpEntity entity = response.getEntity();
            context.getCookieStore().clear();
            String string = EntityUtils.toString((HttpEntity)entity, (String)"utf-8");
            return string;
        }
        catch (ConnectionPoolTimeoutException e) {
            log.error("Exception: \u8fde\u63a5\u6c60\u8d85\u65f6.");
            throw e;
        }
        catch (ConnectTimeoutException e) {
            log.error("Exception: \u8fde\u63a5\u8d85\u65f6");
            throw e;
        }
        catch (SocketTimeoutException e) {
            log.error("Exception: Socket\u8d85\u65f6.");
            throw e;
        }
        catch (ConnectException e) {
            log.error("Exception: \u8fde\u63a5\u88ab\u62d2\u7edd.");
            throw e;
        }
        catch (Exception e) {
            log.error("HTTP Exception", (Throwable)e);
            throw e;
        }
        finally {
            httpPost.abort();
            if (response != null) {
                response.close();
            }
        }
    }

    public static String doPost(String url, String content) throws Exception {
        String result;
        log.info("API\uff0cPOST\u8fc7\u53bb\u7684\u6570\u636e\u662f\uff1a");
        log.info(content);
        HttpPost httpPost = new HttpPost(url);
        StringEntity postEntity = new StringEntity(content, "UTF-8");
        httpPost.addHeader("Content-type", "application/json");
        httpPost.setEntity((HttpEntity)postEntity);
        log.debug("\u6267\u884c\u8bf7\u6c42 " + httpPost.getRequestLine());
        CloseableHttpResponse response = null;
        try {
            response = httpclient.execute((HttpUriRequest)httpPost);
            HttpEntity entity = response.getEntity();
            result = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
        }
        catch (ConnectionPoolTimeoutException e) {
            log.error("Exception: \u8fde\u63a5\u6c60\u8d85\u65f6.");
            throw new Exception(e);
        }
        catch (ConnectTimeoutException e) {
            log.error("Exception: \u8fde\u63a5\u8d85\u65f6");
            throw new Exception(e);
        }
        catch (SocketTimeoutException e) {
            log.error("Exception: Socket\u8d85\u65f6.");
            throw new Exception(e);
        }
        catch (ConnectException e) {
            log.error("Exception: \u8fde\u63a5\u88ab\u62d2\u7edd.");
            throw new Exception(e);
        }
        catch (Exception e) {
            log.error("HTTP Exception", (Throwable)e);
            throw e;
        }
        finally {
            httpPost.abort();
            if (response != null) {
                response.close();
            }
        }
        return result;
    }

    static {
        httpclient = null;
        log = LoggerFactory.getLogger(HttpClientUtil.class);
        SocketConfig socketConfig = SocketConfig.custom().setSoKeepAlive(true).setSoTimeout(60000).setTcpNoDelay(false).setSoReuseAddress(true).setSoKeepAlive(true).build();
        ConnectionConfig connectionConfig = ConnectionConfig.custom().setBufferSize(4096).build();
        requestRetryHandler = new /* Unavailable Anonymous Inner Class!! */;
        try {
            sslcontext = SSLContexts.custom().loadTrustMaterial(null, (TrustStrategy)new TrustSelfSignedStrategy()).build();
            sslsf = new SSLConnectionSocketFactory(sslcontext, SSLConnectionSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        connectionManager = new PoolingHttpClientConnectionManager(RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)sslsf).build());
        connectionManager.setDefaultSocketConfig(socketConfig);
        connectionManager.setDefaultConnectionConfig(connectionConfig);
        connectionManager.setMaxTotal(800);
        connectionManager.setDefaultMaxPerRoute(250);
        connectionManager.closeExpiredConnections();
        connectionManager.closeIdleConnections(0L, TimeUnit.SECONDS);
        httpclient = HttpClients.custom().addInterceptorFirst((HttpRequestInterceptor)new GZIPRequestInterceptor()).addInterceptorFirst((HttpResponseInterceptor)new GZIPResponseInterceptor()).setConnectionManager((HttpClientConnectionManager)connectionManager).setDefaultConnectionConfig(connectionConfig).setRetryHandler(requestRetryHandler).build();
    }
}

