/*
 * Decompiled with CFR 0.152.
 */
package com.biz.commondocker.util;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.IOException;
import java.io.Writer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.apache.commons.lang.StringUtils;
import org.springframework.util.Assert;

/*
 * Exception performing whole class analysis ignored.
 */
public final class JsonUtils {
    private static ObjectMapper mapper = new ObjectMapper();
    private static final String DEFAULT_GLOBAL_DATE_PATTERN = "yyyy-MM-dd HH:mm:ss";

    private JsonUtils() {
    }

    public static String toJson(Object value) {
        try {
            String valueJson = mapper.writeValueAsString(value);
            return valueJson;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <T> T toObject(String json, Class<T> valueType) {
        Assert.hasText((String)json);
        Assert.notNull(valueType);
        try {
            return (T)mapper.readValue(json, valueType);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <T> T toObject(String json, Class<T> valueType, String dateFomat) {
        Assert.hasText((String)json);
        Assert.notNull(valueType);
        try {
            mapper.setDateFormat((DateFormat)new SimpleDateFormat(dateFomat));
            return (T)JsonUtils.toObject((String)json, valueType);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <T> T toObject(String json, TypeReference<?> typeReference) {
        Assert.hasText((String)json);
        Assert.notNull(typeReference);
        try {
            return (T)mapper.readValue(json, typeReference);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <T> T toObject(String json, JavaType javaType) {
        Assert.hasText((String)json);
        Assert.notNull((Object)javaType);
        try {
            return (T)mapper.readValue(json, javaType);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void writeValue(Writer writer, Object value) {
        try {
            mapper.writeValue(writer, value);
        }
        catch (JsonGenerationException e) {
            e.printStackTrace();
        }
        catch (JsonMappingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static <T> String convertList2Json(List<T> objects, Class clazz) throws IOException {
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        return mapper.writeValueAsString(objects);
    }

    public static <T> List<T> toObjectList(String json, Class<T> clazz) {
        ArrayList<Object> lists = new ArrayList<Object>();
        if (StringUtils.isBlank((String)json)) {
            return lists;
        }
        List tempList = (List)JsonUtils.toObject((String)json, new ArrayList().getClass());
        for (Map tempMap : tempList) {
            try {
                lists.add(mapper.readValue(JsonUtils.toJson((Object)tempMap), clazz));
            }
            catch (JsonParseException e) {
                e.printStackTrace();
            }
            catch (JsonMappingException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return lists;
    }

    static {
        mapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        mapper.setTimeZone(TimeZone.getTimeZone("GMT+8"));
        mapper.setDateFormat((DateFormat)simpleDateFormat);
    }
}

