/*
 * Decompiled with CFR 0.152.
 */
package com.biz.commondocker.util;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.Assert;

/*
 * Exception performing whole class analysis ignored.
 */
public class WebUtil {
    private static final String XCOOKIE_PREFIX = "X1919_COOKIE";

    private WebUtil() {
    }

    public static void addCookie(HttpServletRequest request, HttpServletResponse response, String name, String value, Integer maxAge, String path, String domain, Boolean secure) {
        Assert.notNull((Object)request);
        Assert.notNull((Object)response);
        Assert.hasText((String)name);
        try {
            String secureStr;
            String maxAgeStr = "";
            name = URLEncoder.encode(name, "UTF-8");
            value = URLEncoder.encode(value, "UTF-8");
            if (path == null) {
                path = "";
            }
            if (domain == null) {
                domain = "";
            }
            Cookie cookie = new Cookie(name, value);
            if (maxAge != null) {
                cookie.setMaxAge(maxAge.intValue());
                maxAgeStr = maxAge.toString();
            } else {
                maxAgeStr = "";
            }
            if (StringUtils.isNotEmpty((CharSequence)path)) {
                cookie.setPath(path);
            } else {
                cookie.setPath("/");
            }
            if (StringUtils.isNotEmpty((CharSequence)domain)) {
                cookie.setDomain(domain);
            }
            if (secure != null) {
                cookie.setSecure(secure.booleanValue());
                secureStr = secure.toString();
            } else {
                secureStr = "";
            }
            response.addCookie(cookie);
            response.addHeader("X1919_COOKIE-" + name, value + ";" + domain + ";" + path + ";" + maxAgeStr + ";" + secureStr);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    public static void addCookie(HttpServletRequest request, HttpServletResponse response, String name, String value, Integer maxAge, String path) {
        WebUtil.addCookie((HttpServletRequest)request, (HttpServletResponse)response, (String)name, (String)value, (Integer)maxAge, (String)path, null, null);
    }

    public static void addCookie(HttpServletRequest request, HttpServletResponse response, String name, String value) {
        WebUtil.addCookie((HttpServletRequest)request, (HttpServletResponse)response, (String)name, (String)value, null, (String)request.getContextPath(), (String)WebUtil.getDomain((HttpServletRequest)request), null);
    }

    public static String getCookie(HttpServletRequest request, String name) {
        Assert.notNull((Object)request);
        Assert.hasText((String)name);
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            try {
                name = URLEncoder.encode(name, "UTF-8");
                for (Cookie cookie : cookies) {
                    if (!name.equals(cookie.getName())) continue;
                    return URLDecoder.decode(cookie.getValue(), "UTF-8");
                }
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return WebUtil.getXCookie((HttpServletRequest)request, (String)name);
    }

    private static String getXCookie(HttpServletRequest request, String name) {
        String xCookieStr = request.getHeader("X1919_COOKIE");
        if (StringUtils.isBlank((CharSequence)xCookieStr)) {
            return null;
        }
        String[] xCookies = xCookieStr.split(";");
        if (xCookies.length == 0) {
            return null;
        }
        String value = null;
        for (int i = 0; i < xCookies.length; ++i) {
            value = WebUtil.getXCookieValue((String)name, (String)xCookies[i]);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    private static String getXCookieValue(String name, String line) {
        try {
            String[] parts = line.split("=", 2);
            if (parts.length < 2) {
                return null;
            }
            String key = URLDecoder.decode(parts[0], "UTF-8");
            if (name.equalsIgnoreCase(key)) {
                return URLDecoder.decode(parts[1], "UTF-8");
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return null;
    }

    public static void removeCookie(HttpServletRequest request, HttpServletResponse response, String name, String path, String domain) {
        Assert.notNull((Object)request);
        Assert.notNull((Object)response);
        Assert.hasText((String)name);
        try {
            name = URLEncoder.encode(name, "UTF-8");
            Cookie cookie = new Cookie(name, null);
            cookie.setMaxAge(0);
            if (StringUtils.isNotEmpty((CharSequence)path)) {
                cookie.setPath(path);
            }
            if (StringUtils.isNotEmpty((CharSequence)domain)) {
                cookie.setDomain(domain);
            }
            response.addCookie(cookie);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    public static void removeCookie(HttpServletRequest request, HttpServletResponse response, String name, String path) {
        WebUtil.removeCookie((HttpServletRequest)request, (HttpServletResponse)response, (String)name, (String)path, null);
    }

    public static String getDomain(HttpServletRequest request) {
        StringBuffer url = request.getRequestURL();
        String uri = request.getRequestURI();
        int begin = url.indexOf("//");
        begin = begin > 0 ? begin + 2 : 0;
        int end = StringUtils.equals((CharSequence)uri, (CharSequence)"/") ? url.lastIndexOf(uri) : url.indexOf(uri);
        end = end > 0 ? end : url.length();
        return url.substring(begin, end);
    }

    public static String getHttpDomain(HttpServletRequest request) {
        StringBuffer url = request.getRequestURL();
        String tempContextUrl = url.delete(url.length() - request.getRequestURI().length(), url.length()).toString();
        return tempContextUrl;
    }

    public static boolean isAjaxRequest(HttpServletRequest request) {
        return StringUtils.isNotBlank((CharSequence)request.getHeader("x-requested-with"));
    }
}

