/*
 * Decompiled with CFR 0.152.
 */
package com.biz.commondocker.zookeeper;

import com.alibaba.dubbo.common.URL;
import com.alibaba.dubbo.remoting.zookeeper.ChildListener;
import com.alibaba.dubbo.remoting.zookeeper.support.AbstractZookeeperClient;
import com.biz.commondocker.zookeeper.CuratorZookeeperClient;
import java.util.List;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.api.BackgroundPathable;
import org.apache.curator.framework.api.CuratorWatcher;
import org.apache.curator.retry.RetryNTimes;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CuratorZookeeperClient
extends AbstractZookeeperClient<CuratorWatcher> {
    private Logger logger = LoggerFactory.getLogger(CuratorZookeeperClient.class);
    private final CuratorFramework client;

    public CuratorZookeeperClient(URL url) {
        super(url);
        this.logger.info("build client use url:{}", (Object)url);
        CuratorFrameworkFactory.Builder builder = CuratorFrameworkFactory.builder().connectString(url.getBackupAddress()).retryPolicy((RetryPolicy)new RetryNTimes(Integer.MAX_VALUE, 1000)).connectionTimeoutMs(5000);
        String authority = url.getAuthority();
        if (authority != null && authority.length() > 0) {
            builder = builder.authorization("digest", authority.getBytes());
        }
        this.client = builder.build();
        this.client.getConnectionStateListenable().addListener((Object)new /* Unavailable Anonymous Inner Class!! */);
        this.client.start();
        this.logger.info("zookeeprt client use started");
    }

    public void createPersistent(String path) {
        try {
            this.client.create().forPath(path);
        }
        catch (KeeperException.NodeExistsException nodeExistsException) {
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    public void createEphemeral(String path) {
        try {
            ((ACLBackgroundPathAndBytesable)this.client.create().withMode(CreateMode.EPHEMERAL)).forPath(path);
        }
        catch (KeeperException.NodeExistsException nodeExistsException) {
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    public void delete(String path) {
        try {
            this.client.delete().forPath(path);
        }
        catch (KeeperException.NoNodeException noNodeException) {
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    public List<String> getChildren(String path) {
        try {
            return (List)this.client.getChildren().forPath(path);
        }
        catch (KeeperException.NoNodeException e) {
            return null;
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    public boolean isConnected() {
        return this.client.getZookeeperClient().isConnected();
    }

    public void doClose() {
        this.client.close();
    }

    public CuratorWatcher createTargetChildListener(String path, ChildListener listener) {
        return new CuratorWatcherImpl(this, listener);
    }

    public List<String> addTargetChildListener(String path, CuratorWatcher listener) {
        try {
            return (List)((BackgroundPathable)this.client.getChildren().usingWatcher(listener)).forPath(path);
        }
        catch (KeeperException.NoNodeException e) {
            return null;
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    public void removeTargetChildListener(String path, CuratorWatcher listener) {
        ((CuratorWatcherImpl)listener).unwatch();
    }

    static /* synthetic */ void access$000(CuratorZookeeperClient x0, int x1) {
        x0.stateChanged(x1);
    }

    static /* synthetic */ void access$100(CuratorZookeeperClient x0, int x1) {
        x0.stateChanged(x1);
    }

    static /* synthetic */ void access$200(CuratorZookeeperClient x0, int x1) {
        x0.stateChanged(x1);
    }

    static /* synthetic */ CuratorFramework access$300(CuratorZookeeperClient x0) {
        return x0.client;
    }
}

