/*
 * Decompiled with CFR 0.152.
 */
package com.biz.commondocker.zookeeper;

import com.biz.commondocker.asserts.SystemAsserts;
import com.biz.commondocker.zookeeper.SoaIndexFactory;
import com.biz.commondocker.zookeeper.ZooClient;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.zookeeper.CreateMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SoaIndexFactory {
    private static final Logger logger = LoggerFactory.getLogger(SoaIndexFactory.class);
    private static final String soaIdxBaseNodePath = "/bozhi/run/soaIdx";
    private static Integer soaIdx = null;
    private static int MAX_SOA_IDX = 512;
    private static final String NODE_SEPARATOR = "/";

    private SoaIndexFactory() {
        block6: {
            try {
                List aliveNodes;
                CuratorFramework curator = ZooClient.getClient();
                if (soaIdx != null) break block6;
                if (curator.checkExists().forPath(soaIdxBaseNodePath) == null) {
                    ((ACLBackgroundPathAndBytesable)curator.create().creatingParentsIfNeeded().withMode(CreateMode.PERSISTENT)).forPath(soaIdxBaseNodePath);
                }
                if (CollectionUtils.isNotEmpty((Collection)(aliveNodes = curator.getZookeeperClient().getZooKeeper().getChildren(soaIdxBaseNodePath, false)))) {
                    for (int i = 1; i <= MAX_SOA_IDX; ++i) {
                        if (aliveNodes.contains(String.valueOf(i))) continue;
                        soaIdx = i;
                        break;
                    }
                } else {
                    soaIdx = 1;
                }
                SystemAsserts.notNull((Object)soaIdx, (String)"\u521d\u59cb\u5316soaIdx\u5931\u8d25", (Object[])new Object[0]);
                ((ACLBackgroundPathAndBytesable)curator.create().creatingParentsIfNeeded().withMode(CreateMode.EPHEMERAL)).forPath("/bozhi/run/soaIdx/" + soaIdx);
            }
            catch (Exception e) {
                logger.error("\u521d\u59cb\u5316soaIdx\u5931\u8d25", (Throwable)e);
            }
        }
    }

    public static SoaIndexFactory newInstance() {
        return SoaIdxFactoryHolder.instance;
    }

    public int getSoaIdx() {
        return soaIdx;
    }
}

