/*
 * Decompiled with CFR 0.152.
 */
package com.biz.commondocker.zookeeper;

import com.biz.commondocker.exception.SystemException;
import com.biz.commondocker.zookeeper.ZkProperties;
import com.biz.commondocker.zookeeper.ZooClient;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.api.BackgroundPathable;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.Watcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class ZkProperties {
    private static final Logger LOG = LoggerFactory.getLogger(ZkProperties.class);
    private Properties config;
    private byte[] configBytes;

    public ZkProperties(String path) {
        this(path, false);
    }

    public ZkProperties(String path, boolean watch) {
        try {
            byte[] data;
            CuratorFramework curator = ZooClient.getClient();
            if (curator.checkExists().forPath(path) == null) {
                LOG.debug("zk \u6587\u4ef6:{} \u4e0d\u5b58\u5728, \u521b\u5efazk\u6587\u4ef6", (Object)path);
                ((ACLBackgroundPathAndBytesable)curator.create().creatingParentsIfNeeded().withMode(CreateMode.PERSISTENT)).forPath(path);
            }
            if (watch) {
                1 watcher = new /* Unavailable Anonymous Inner Class!! */;
                data = (byte[])((BackgroundPathable)curator.getData().usingWatcher((Watcher)watcher)).forPath(path);
            } else {
                data = (byte[])curator.getData().forPath(path);
            }
            this.reloadProperties(data);
            LOG.debug("\u52a0\u8f7dzk properties : {} \u6210\u529f", (Object)path);
        }
        catch (Exception e) {
            throw new SystemException("\u521d\u59cb\u5316\u5931\u8d25", (Throwable)e);
        }
    }

    private void reloadProperties(byte[] data) throws IOException {
        Properties c = ZkProperties.createEmptyConfig();
        if (data != null) {
            c.load(new ByteArrayInputStream(data));
        }
        this.config = c;
        this.configBytes = data;
    }

    public String getProperty(String key) {
        return this.config == null ? null : this.config.getProperty(key);
    }

    public Long getLong(String key) {
        String p = this.getProperty(key);
        return StringUtils.isBlank((String)p) ? null : Long.valueOf(p);
    }

    public Properties getProperties() {
        return this.config;
    }

    public byte[] getPropertiesBytes() {
        return this.configBytes;
    }

    private static Properties createEmptyConfig() {
        Properties c = new Properties();
        return c;
    }

    static /* synthetic */ Logger access$000() {
        return LOG;
    }

    static /* synthetic */ void access$100(ZkProperties x0, byte[] x1) throws IOException {
        x0.reloadProperties(x1);
    }
}

