/*
 * Decompiled with CFR 0.152.
 */
package com.biz.commondocker.zookeeper;

import com.biz.commondocker.exception.SystemException;
import com.biz.commondocker.util.ConfigUtil;
import com.biz.commondocker.zookeeper.ZkPropertiesUtil;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.api.BackgroundPathable;
import org.apache.curator.retry.RetryNTimes;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.Watcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class ZkPropertiesUtil {
    private static final Logger log = LoggerFactory.getLogger(ZkPropertiesUtil.class);
    private Properties config;
    private byte[] configBytes;
    private static CuratorFramework client;

    public ZkPropertiesUtil(String path) {
        this(path, false);
    }

    public String getProperty(String key) {
        return this.config == null ? null : this.config.getProperty(key);
    }

    public Properties getProperties() {
        return this.config;
    }

    public byte[] getPropertiesBytes() {
        return this.configBytes;
    }

    private static Properties createEmptyConfig() {
        return new Properties();
    }

    public ZkPropertiesUtil(String path, boolean watch) {
        try {
            byte[] data;
            CuratorFramework curator = ZkPropertiesUtil.getClient();
            if (curator.checkExists().forPath(path) == null) {
                log.debug("zk \u6587\u4ef6:{} \u4e0d\u5b58\u5728, \u521b\u5efazk\u6587\u4ef6", (Object)path);
                ((ACLBackgroundPathAndBytesable)curator.create().creatingParentsIfNeeded().withMode(CreateMode.PERSISTENT)).forPath(path);
            }
            if (watch) {
                1 watcher = new /* Unavailable Anonymous Inner Class!! */;
                data = (byte[])((BackgroundPathable)curator.getData().usingWatcher((Watcher)watcher)).forPath(path);
            } else {
                data = (byte[])curator.getData().forPath(path);
            }
            this.reloadProperties(data);
            log.debug("\u52a0\u8f7dzk properties : {} \u6210\u529f", (Object)path);
        }
        catch (Exception e) {
            throw new SystemException("\u521d\u59cb\u5316\u5931\u8d25", (Throwable)e);
        }
    }

    private void reloadProperties(byte[] data) throws IOException {
        Properties c = ZkPropertiesUtil.createEmptyConfig();
        if (data != null) {
            c.load(new ByteArrayInputStream(data));
        }
        this.config = c;
        this.configBytes = data;
    }

    public static synchronized CuratorFramework getClient() {
        if (client == null) {
            String zookeeperUrl = ZkPropertiesUtil.getZookeeperUrl().replace("zookeeper://", "").replace("?backup=", ",");
            log.debug("zookeeperUrl: {}", (Object)zookeeperUrl);
            try {
                client = CuratorFrameworkFactory.builder().connectString(zookeeperUrl).retryPolicy((RetryPolicy)new RetryNTimes(Integer.MAX_VALUE, 1000)).connectionTimeoutMs(8000).build();
                client.start();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return client;
    }

    public static String getZookeeperUrl() {
        String url = System.getProperty("zookeeper.url");
        if (url == null) {
            try {
                url = ConfigUtil.getString((String)"config.properties", (String)"zookeeper.url");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return url;
    }

    public static boolean isConfiguredByZoo() {
        return ZkPropertiesUtil.getZookeeperUrl() != null;
    }

    public static Properties loadFromFileOrZooKeeper(String zooPath, String classPath) {
        Object zkProperties;
        Properties conf = new Properties();
        InputStream inputStream = null;
        try {
            if (ZkPropertiesUtil.isConfiguredByZoo() && StringUtils.isNotBlank((String)zooPath)) {
                zkProperties = new ZkPropertiesUtil(zooPath);
                inputStream = new ByteArrayInputStream(zkProperties.getPropertiesBytes());
            } else {
                inputStream = new FileInputStream(ConfigUtil.class.getResource("/").getPath() + classPath);
            }
            conf.load(new InputStreamReader(inputStream, "UTF-8"));
            zkProperties = conf;
        }
        catch (Exception e) {
            try {
                throw new RuntimeException("\u8f7d\u914d\u7f6e\u5931\u8d25", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)inputStream);
        return zkProperties;
    }

    public static void close() {
        if (client != null) {
            client.close();
        }
    }

    static /* synthetic */ Logger access$000() {
        return log;
    }

    static /* synthetic */ void access$100(ZkPropertiesUtil x0, byte[] x1) throws IOException {
        x0.reloadProperties(x1);
    }
}

