package com.biz.interfacedocker.common.page;

import java.io.Serializable;
import java.util.List;

public class PageInfo<T> implements Serializable{

	private static final long serialVersionUID = -4076251710795431210L;
	
	/**每页显示记录数**/
	private int showCount = 10;
	/**总页数**/
    private int totalPage;
    /**总记录数**/
    private int totalResult;
    /**当前页**/
    private int page;
    /****/
    private String sortField;
    private String order;
    /**数据集合**/
    private List<T> resultList;
    
	public int getShowCount() {
		return showCount;
	}
	public void setShowCount(int showCount) {
		this.showCount = showCount;
	}
	public int getTotalPage() {
		return totalPage;
	}
	public void setTotalPage(int totalPage) {
		this.totalPage = totalPage;
	}
	public int getTotalResult() {
		return totalResult;
	}
	public void setTotalResult(int totalResult) {
		totalPage = (totalResult+showCount-1)/showCount;
		this.totalResult = totalResult;
	}
	public int getCurrentResult() {
		return (page-1)*showCount;
	}
	public String getSortField() {
		return sortField;
	}
	public void setSortField(String sortField) {
		this.sortField = sortField;
	}
	public String getOrder() {
		return order;
	}
	public void setOrder(String order) {
		this.order = order;
	}
	public int getPage() {
		return page;
	}
	public void setPage(int page) {
		this.page = page;
	}
	public List<T> getResultList() {
		return resultList;
	}
	public void setResultList(List<T> resultList) {
		this.resultList = resultList;
	}
	
}
