package com.biz.interfacedocker.mdbWeb.service;

import java.util.List;

import com.biz.interfacedocker.mdbWeb.vo.CpmdWebVo;
import com.biz.interfacedocker.mdbWeb.vo.PromotionPackageWebVo;
import com.biz.interfacedocker.mdbWeb.vo.PromotionWebVo;
import com.biz.interfacedocker.mdbWeb.vo.common.Pager;

public interface CpmdWebApiService {

	/**
	 * 返回所有商品主数据
	 */
	public List<CpmdWebVo> findAll();

	/**
	 * 根据查询条件分页返回商品主数据信息
	 * 
	 * @Title: findCpmdByParams
	 * @param MATNR
	 *            商品编码
	 * @param MAKTX
	 *            商品描述
	 * @param ZZTYPE
	 *            商品大类编码
	 * @param ZZSUBTYPE
	 *            商品小类编码
	 * @param pageNum
	 *            显示第几页
	 * @param pageSize
	 *            每页显示条数
	 * @param request
	 * @return
	 * @author: zhouyannian
	 * @date: 2016年7月21日 上午10:29:36
	 */
	public Pager<CpmdWebVo> findCpmdByParams(String MATNR, String MAKTX,
			String ZZTYPE, String ZZSUBTYPE, Integer pageNum, Integer pageSize);
	
	/**
	 * 根据查询条件返回商品主数据信息
	 * 
	 * @Title: findCpmdListByParams
	 * @param MATNR
	 *            商品编码
	 * @param MAKTX
	 *            商品描述
	 * @param ZZTYPE
	 *            商品大类编码
	 * @param ZZSUBTYPE
	 *            商品小类编码
	 * @param request
	 * @return
	 * @author: zhouyannian
	 * @date: 2016年7月21日 上午10:29:36
	 */
	public List<CpmdWebVo> findCpmdListByParams(String MATNR, String MAKTX,
			String ZZTYPE, String ZZSUBTYPE);
	
	/**
	 * 根据商品编码或商品名称返回商品主数据
	 * 
	 * @Title: findCpmdById
	 * @param param
	 *            商品编码/商品名称
	 * @param columnName
	 *            排序列名
	 * @param sort
	 *            排序方式
	 * @param pageNum
	 *            显示第几页
	 * @param pageSize
	 *            每页显示多少条                                    
	 * @param request
	 * @return
	 * @author: zhouyannian
	 * @date: 2016年8月16日 下午10:29:36
	 */
	public Pager<CpmdWebVo> findCpmdPageById(String param, String columnName,
			String sort, Integer pageNum, Integer pageSize); 
	
	/**
	 * 根据商品编码返回商品主数据
	 * 
	 * @Title: findCpmdListByIds
	 * @param MATNR
	 *            商品编码
	 * @param request
	 * @return
	 * @author: zhouyannian
	 * @date: 2016年7月21日 上午10:29:36
	 */
	public List<CpmdWebVo> findCpmdListByIds(String... MATNR); 
	
	
	
	/**
	 * 根据商品编码返回商品主数据
	 * 
	 * @Title: findCpmdById
	 * @param MATNR
	 *            商品编码
	 * @param request
	 * @return
	 * @author: zhouyannian
	 * @date: 2016年7月21日 上午10:29:36
	 */
	public CpmdWebVo findCpmdById(String MATNR); 
	
	/**
	 * 根据组合商品编码返回组合商品主数据
	 * 
	 * @Title: findPromotionById
	 * @param promotionId
	 *            商品编码
	 * @param pageNum
	 *            显示第几页
	 * @param pageSize
	 *            每页显示多少条
	 * @param request
	 * @return
	 * @author: zhouyannian
	 * @date: 2016年7月21日 上午10:29:36
	 */
	public  Pager<PromotionWebVo> findPromotionPageById(String promotionId,Integer pageNum,Integer pageSize);
	
	/**
	 * 根据更新时间查询商品
	 * 
	 * @param updatetimeLt
	 *            开始时间
     * @param updatetimeGt
	 *            结束时间
	 * @return
	 */
	public List<CpmdWebVo> findCpmdByUpdatetime(String updatetimeLt,String updatetimeGt);
	
	/**
	 * @Description: 通过包装号查询组合商品详细信息 
	 * @param promotionId 组合商品包装号
	 * @throws
	 */
	public PromotionPackageWebVo findPromotionPackageInfo(final String promotionId);
	
	/**
	 * @Description: 分页查询组合商品详细信息
	 * @param pageNum 显示第几页
	 * @param pageSize 每页显示多少条
	 * @throws
	 */
	public Pager<PromotionPackageWebVo> findPromotionPackageByPage(Integer pageNum, Integer pageSize);
	
	/**
	 * 根据商品编码判断商品是否存在
	 * 
	 * @param productId
	 *            商品编号
	 * @return
	 */
	public boolean productIsExist(String productId);
}
