package com.biz.interfacedocker.mdbWeb.service;

import java.util.List;
import com.biz.interfacedocker.mdbWeb.vo.LocationWebVo;
import com.biz.interfacedocker.mdbWeb.vo.common.Pager;

public interface LocationWebApiService {

	/**
	 * 返回所有省市区主数据
	 */
	public List<LocationWebVo> findAll();
	
	/**
	 * 返回所有省
	 */
	public List<LocationWebVo> findProvince();
	
	/**
	 * 根据省编码返回所有市
	 * 
	 * @Title: findCityByProvince
	 * @param provinceId
	 *            省编码
	 * @param request
	 * @return
	 * @author: zhouyannian
	 * @date: 2016年8月4日 下午17:29:36
	 */
	public List<LocationWebVo> findCityByProvince(String provinceId);
	
    /**
	 * 根据市编码返回所有区/县
	 * 
	 * @Title: findAreaByCity
	 * @param cityId
	 *            市编码
	 * @param request
	 * @return
	 * @author: zhouyannian
	 * @date: 2016年8月4日 下午17:29:36
	 */
	public List<LocationWebVo> findAreaByCity(String cityId);

	/**
	 * 根据查询条件分页返回省市区主数据信息
	 * 
	 * @Title: findLocationByParams
	 * @param REGIO
	 *            省编码
	 * @param CITYC
	 *            市编码
	 * @param TRANSPZONE
	 *            区/县编码
	 * @param request
	 * @return
	 * @author: zhouyannian
	 * @date: 2016年7月23日 上午10:29:36
	 */
	public Pager<LocationWebVo> findLocationByParams(String REGIO, String CITYC,
			String TRANSPZONE, Integer pageNum, Integer pageSize);
	
	/**
	 * 根据省编码返回省名称
	 * 
	 * @Title: findProvinceById
	 * @param provinceId
	 *            省编码
	 * @param request
	 * @return
	 * @author: zhouyannian
	 * @date: 2016年8月4日 下午17:29:36
	 */
	public LocationWebVo findProvinceById(String provinceId);
    
    /**
	 * 根据市编码返回市名称
	 * 
	 * @Title: findCityById
	 * @param provinceId
	 *            省编码
	 * @param request
	 * @return
	 * @author: zhouyannian
	 * @date: 2016年8月4日 下午17:29:36
	 */
	public LocationWebVo findCityById(String cityId);
    
    /**
	 * 根据区/县编码返回区/县名称
	 * 
	 * @Title: findAreaById
	 * @param provinceId
	 *            省编码
	 * @param request
	 * @return
	 * @author: zhouyannian
	 * @date: 2016年8月4日 下午17:29:36
	 */
	public LocationWebVo findAreaById(String areaId);
}
