package com.biz.interfacedocker.mdbWeb.service;

import java.util.List;

import com.biz.interfacedocker.mdbWeb.vo.SmdWebVo;
import com.biz.interfacedocker.mdbWeb.vo.SuppliersWebVo;
import com.biz.interfacedocker.mdbWeb.vo.WarehouseWebVo;
import com.biz.interfacedocker.mdbWeb.vo.common.Pager;

public interface SuppliersWebApiService
{

	/**
	 * 返回所有供应商主数据
	 */
	public List<SuppliersWebVo> findAll();

	/**
	 * 分页返回所有供应商主数据
	 * 
	 * @Title: findWarehouseByParams
	 * @param pageNum
	 *            显示第几页
	 * @param pageSize
	 *            每页显示条数
	 * @return
	 * @author: zhouyannian
	 * @date: 2016年8月26日 上午10:29:36
	 */

	public Pager<SuppliersWebVo> findAllSuppliersPage(Integer pageNum,
			Integer pageSize);
	/**
	 * 通过供应商编码和名称分页返回所有供应商信息
	 * 
	 * @Title: findSuppliersPageByIdAndName
	 * @param supplierId
	 *            供应商编码
	 * @param supplierName
	 *            供应商名称
	 * @param pageNum
	 *            显示第几页
	 * @param pageSize
	 *            每页显示条数
	 * @param request
	 * @return
	 * @author: zhouyannian
	 * @date: 2016年11月17日 上午10:29:36
	 */

	public Pager<SuppliersWebVo> findSuppliersPageByIdAndName(
			String supplierId, String supplierName, Integer pageNum,
			Integer pageSize);
}
