package com.biz.interfacedocker.messagedocker.service;

import java.lang.reflect.InvocationTargetException;
import java.util.List;

import com.biz.interfacedocker.messagedocker.vo.SendMsgVo;

import com.biz.interfacedocker.common.JsonResult;

public interface MessageAdminApiService {	
	/****
	 * 发送短信
	 * @param sendMsgData List<SendMsgVo> 转json字符串
	 * @return
	 */
	public Boolean sendMessage(String sendMsgData);
	
	/**
	 * 获取手机短信发送情况
	 * @param mobile
	 * @param content
	 * @return
	 */
	public JsonResult<SendMsgVo> getSendMsgVo(String mobile,String content);
	
	/**
	 * 获取同一手机号码单天成功发送短信情况
	 * @param mobile
	 * @return
	 * @throws IllegalAccessException
	 * @throws InvocationTargetException
	 */
	public List<SendMsgVo> getSendMsgVoDay(String mobile) throws IllegalAccessException, InvocationTargetException;
}
