/**
 * @Description: 
 * @ClassName: com.biz.interfacedocker.orderdocker.service.OmsCenterOrderApiService
 * @author: TRivers.chen(Administrator)
 * @date: 2016年6月18日 下午3:15:43 
 */
package com.biz.interfacedocker.orderdocker.service;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

import com.biz.interfacedocker.orderdocker.vo.DeliveryStatusReverseVo;

/**
 * @Description: 
 * @ClassName: com.biz.interfacedocker.orderdocker.service.OmsCenterOrderApiService
 * @author: TRivers.chen(Administrator)
 * @date: 2016年6月18日 下午3:15:43 
 *
 */
public interface OmsCenterOrderApiService {
	
	/**
	 * 查询订单在pos是否存在
	 * @Title: queryOrderIsExistInPos 
	 * @param orderBn 订单编号
	 * @param storeNo 门店编号
	 * @return
	 * @author: TRivers.chen(Administrator)
	 * @date: 2016年8月19日 下午12:51:22
	 */
	public String queryOrderIsExistInPos(String orderBn,String storeNo);
	
	/**
	 * 接收配送单状态反写
	 * @Title: receiveDeliveryStatus 
	 * @param deliveryStatusVo
	 * @author: TRivers.chen(Administrator)
	 * @date: 2016年7月9日 下午12:55:18
	 */
	public Boolean receiveDeliveryStatus(DeliveryStatusReverseVo deliveryStatusVo);
	/**
	 * 推送订单状态表信息,更新订单状态
	 * @Title: pushOrderStatusReverse 
	 * @param orderStatusReverseJson 订单状态信息json
	 * @return
	 * @author: TRivers.chen(Administrator)
	 * @date: 2016年6月18日 下午3:32:00
	 */
	public Boolean pushOrderStatusReverse(String orderStatusReverseJson);
	
	/**
	 * 接收Pos端的推送的退货单
	 * @Title: receiveReturnGoodsByPos 
	 * @param returnGoodsJson 退货单信息Json
	 * @author: TRivers.chen(Administrator)
	 * @date: 2016年6月18日 下午5:21:02
	 */
	public String receiveReturnGoodsByPos(String returnGoodsJson);
	
	/**
	 * 保存退货单
	 * @Title: receiveReturnGoodsByPos 
	 * @param returnGoodsJson 退货单信息
	 * @param flag 是否推送pos
	 * @author: TRivers.chen(Administrator)
	 * @date: 2016年6月18日 下午5:54:51
	 */
	public Map<String,Object> saveReturnGoodsDto(String returnGoodsJson  , Boolean flag);

	/**
	 * 根据退货单编号更新退货单申请状态
	 * @Title: updateReturnGoodsStatusByBn 
	 * @param returnGoodsBn 退货单编号
	 * @param status 申请状态
	 * @author: TRivers.chen(Administrator)
	 * @date: 2016年6月16日 下午3:44:34
	 */
	public void updateReturnGoodsStatusByBn(String returnGoodsBn, Integer status);

	/**
	 * 接收订单物流信息推送
	 * @Title: pushOrderLogistics
	 * @param orderLogisticsVo 订单物流信息
	 * @return
	 * @author: TRivers.chen(Administrator)
	 * @date: 2016年6月19日 下午7:47:09
	 */
	public Boolean pushOrderLogistics(String orderLogisticsJson);

	/**
	 *  保存换货生成的退货单和销售单
	 * @Title: changeGoodsHandler 
	 * @param returnGoodsJson 退货单json
	 * @param consigneeJson 收货人Json
	 * @param flag 是否推送pos
	 * @author: TRivers.chen(Administrator)
	 * @throws Exception 
	 * @date: 2016年6月27日 下午12:47:55
	 */
	public Map<String,Object> changeGoodsHandler(String returnGoodsJson, String consigneeJson, Boolean flag) throws Exception;
	
	/**
	 * 保存退款单
	 * @Title: saveRefundOrder 
	 * @param refundOrderJson 退款单详情
	 * @param flag 是否推送给pos
	 * @author: TRivers.chen(Administrator)
	 * @date: 2016年6月14日 下午3:46:02
	 */
	public Map<String,Object> saveRefundOrder(String refundOrderJson,Boolean flag);

    /**
     * 保存并推送退款单到POS
     * @param refundOrderJson 退款单详情
     * @param flag 是否推送给POS
     * @return
     * @author: Weitong Yan
     * @data: 2017年8月29日
     */
    public Map<String,Object> saveAndPushRefundOrderToPos(String refundOrderJson,Boolean flag);

	/**
	 * 批量更新和删除退货商品
	 * @Title: batchUpdateReturnProductInfo 
	 * @param returnGoodsBn 退货单号
	 * @param returnGoodsJson 退货单
	 * @param tempReturnProducts 待更新的退货商品信息
	 * @param returnGoodsType 退货单类型
	 * @param flag 是否推送pos
	 * @param tempProductbns 需要删除的退货商品编号
	 * @author: TRivers.chen(Administrator)
	 * @date: 2016年7月3日 下午12:55:05
	 */
	public Map<String,Object> batchUpdateReturnProductInfo(String returnGoodsBn,String returnGoodsJson,String tempReturnProducts,Integer returnGoodsType,Boolean flag,List<String> tempProductbns);
	
	/**
	 * 更新换货商品信息和收货人信息
	 * @Title: batchUpdateChangeProductAndConsignee 
	 * @param tempReturnProducts 换货商品信息
	 * @param consigneeJson 收货人信息
	 * @param orderBn 订单编号
	 * @param changeGoodsBn 换货单号
	 * @param returnGoodsBn 退货单号
	 * @param tempProductbns 需要删除的商品编号集合
	 * @param customMark 备注
	 * @param flag 是否推送给pos
	 * @author: TRivers.chen(Administrator)
	 * @date: 2016年7月3日 下午6:42:56
	 */
	public Map<String,Boolean> batchUpdateChangeProductAndConsignee(String tempReturnProducts,String consigneeJson,String orderBn,String changeGoodsBn,String returnGoodsBn,List<String> tempProductbns,String customMark,Boolean flag);
	
	/**
	 * 查询退货单是否有创建过退款单
	 * @Title: refundOrderIsExists 
	 * @param returnGoodsBn
	 * @return
	 * @author: TRivers.chen(Administrator)
	 * @date: 2016年7月6日 下午3:26:28
	 */
	public Boolean refundOrderIsExists(String returnGoodsBn);
	
	/**
	 * 退货单审核状态反写
	 * @Title: reverseReturnGoodsStatus 
	 * @param returnGoodsStatusJson 状态信息Json
	 * @author: TRivers.chen(Administrator)
	 * @date: 2016年7月7日 下午5:58:55
	 */
	public Boolean reverseReturnGoodsStatus(String returnGoodsStatusJson);
	

	/**
	 * 推送配送单到配送app
	 * @Title: pushDeliveryToPS 
	 * @param deliveryJson 配送单信息 json 字符串
	 * @author: Omar(OmarZhang)
	 * @date: 2016年7月21日 上午10:50:22
	 */
	public void pushDeliveryToPS(String deliveryJson);
	
	/**
	 * 返回订单里面还没有退换货的商品
	 * @Title: getSurplusProductInOrderBase 
	 * @param items
	 * @param productInfos
	 * @return
	 * @author: TRivers.chen(Administrator)
	 * @date: 2016年7月28日 下午4:26:49
	 */
	public String getSurplusProductInOrderBase(String itemsJson , String productInfosJson);
	
	/**
	 * 查看订单是否已经全部退货
	 * @Title: isSurplusProductInOrder 
	 * @param orderBn
	 * @return true 全部发货  false 部分发货
	 * @author: TRivers.chen(Administrator)
	 * @date: 2016年7月28日 下午4:54:37
	 */
	public Boolean isSurplusProductInOrder(String orderBn);
	
	/**
	 * 计算订单剩余的可退金额
	 * @Title: getEnabledReturnAmountByOrderBn 
	 * @param orderBn
	 * @return
	 * @author: TRivers.chen(Administrator)
	 * @date: 2016年8月31日 上午11:48:48
	 */
	public BigDecimal getEnabledReturnAmountByOrderBn(String orderBn);

	/**
	 * 查询订单状态是否是已分单
	 * 主要是为了pos反写订单状态的时候加个当前订单状态的验证
	 * @Title: findOrderBaseStatus 
	 * @param orderBn
	 * @return
	 * @author: TRivers.chen(Administrator)
	 * @date: 2016年9月7日 下午4:36:19
	 */
	public String findOrderBaseStatus(String orderBn);
	
	/**
	 * 作废退货单
	 * @Title: cancelReturnGoods 
	 * @param returnGoodsBn
	 * @return
	 * @author: TRivers.chen(Administrator)
	 * @date: 2016年12月7日 上午11:24:47
	 */
	public Map<String, Object> cancelReturnGoods(String returnGoodsBn);
	/**
	 * 快喝订单取消接口
	 * @Title: cancel
	 * @param orderBn
	 * @param cancelMask
	 * @return
	 * @author: Javon
	 * @date: 2017年7月31日 下午3:57:34
	 */
	public Map<String, Object> cancel(String orderBn,String cancelMask);
}
