/**
 * @Description: 
 * @ClassName: com.biz.interfacedocker.orderdocker.service.OmsOrderCancleApiService
 * @author: dick.dai(Administrator)
 * @date: 2016年6月27日 下午9:21:21 
 */
package com.biz.interfacedocker.orderdocker.service;

import java.util.Map;

import com.biz.interfacedocker.orderdocker.vo.CancelOrderVo;
import com.biz.interfacedocker.orderdocker.vo.OrderCancelResponseVo;

/**
 * 订单取消暴露接口
 * @Description: 
 * @ClassName: com.biz.interfacedocker.orderdocker.service.OmsOrderCancleApiService
 * @author: dick.dai(Administrator)
 * @date: 2016年6月27日 下午9:21:21 
 *
 */
public interface OmsOrderCancleApiService {
	/**
	 * 通过订单编号逻辑删除订单
	 * @Title: deleteOrderByOrderBn 
	 * @param orderBn
	 * @author: dick.dai(Administrator)
	 * @date: 2016年6月27日 下午9:22:47
	 */
	public String deleteOrderByOrderBn(String orderBn);
	/**
	 * 自有平台调用取消接口
	 * @Title: orderCancelOfPlatform 
	 * @param cancelOrdervo
	 * @return
	 * @author: dick.dai(Administrator)
	 * @date: 2016年7月1日 下午2:59:56
	 */
	public Map<String,String> orderCancelOfPlatform(CancelOrderVo cancelOrdervo);
 
	/**
	 * 调用Pos取消接口
	 * @Title: centerCancelToPos 
	 * @param orderBn 订单编号
	 * @param storeBn 门店编号
	 * @author: dick.dai(Administrator)
	 * @date: 2016年6月29日 下午4:40:58
	 */
	public OrderCancelResponseVo centerCancelToPos(String orderBn,String storeBn);
	/**
	 * 针对cc管理的门店线上订单(即oms订单)的取消
	 * @Title: cancelToMendianOnline 
	 * @param orderBn
	 * @return 
	 * @author: dick.dai(Administrator)
	 * @date: 2016年7月23日 下午12:00:43
	 */
	public String cancelToMendianOnline(String orderBn);
	
	/**
	 * 推送订单到pos
	 * @Title: pushOrderToPosMethod 
	 * @param json
	 * @return
	 * @author: TRivers.chen(Administrator)
	 * @date: 2016年7月25日 下午10:49:22
	 */
	public String pushOrderToPosMethod(String json);
	
	/**
	 * 双11订单批量删单，在原有代码上取消已支付订单状态逻辑删除限制
	 * @Title: batchDeleteOrderByOrderBn 
	 * @param orderBn
	 * @return
	 * @author: Javon 
	 * @date: 2017年10月30日 下午4:41:07
	 */
   public  String batchDeleteOrderByOrderBn(String orderBn);
   /**
    * 门店订单
    *  双11订单批量删单，在原有代码上取消已支付订单状态逻辑删除限制
    * @Title: batchMendianonlineCancel 
    * @param orderBn
    * @return
    * @author: Javon 
    * @date: 2017年10月30日 下午4:49:38
    */
   public String batchMendianonlineCancel(String orderBn);
}
