package com.biz.interfacedocker.orderdocker.vo.orderlist;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 订单基本信息
 */
public class OrderBaseRespVo implements Serializable {

    private static final long serialVersionUID = 2342231417107862962L;
    /**
     * 订单ID
     */
    private Integer id;
    /**
     * 订单来源
     */
    private String ordersource;
    /**
     * 来自节点ID
     */
    private String to_node_id;
    /**
     * 店铺编码
     */
    private String shopBn;
    /**
     * 订单类型: normal,sale,aftersale defalt: normal
     */
    private String orderType;
    /**
     * 订单编号
     */
    private String order_bn;
    /**
     * 商品花费金额
     */
    private BigDecimal cost_item;
    /**
     * 税费（需要发票时）
     */
    private BigDecimal cost_tax;
    /**
     * 订单创建时间
     */
    private Date createtime;
    /**
     * 订单总价
     */
    private BigDecimal cur_amount;
    /**
     * 货币类型
     */
    private String currency;
    /**
     * 客户备注
     */
    private String custom_mark;
    /**
     * 折让 大于0则表示减去，小于0则表示增加
     */
    private Integer discount;
    /**
     * 是否需要发票
     */
    private Boolean is_tax;
    /**
     * 发票类型  普通发票/增值税发票
     */
    private String invoiceType;
    /**
     * 发票抬头
     */
    private String invoiceTitle;
    /**
     * 发票内容
     */
    private String invoiceDetails;
    /**
     * 是否纸质发票
     */
    private Boolean isPaperInvoice;

    /**
     * 纳税人标识号
     */
    private String taxId;
    /**
     * 注册电话
     */
    private String registPhoneNo;
    /**
     * 注册地址
     */
    private String registAddr;
    /**
     * 开户银行
     */
    private String registBank;
    /**
     * 开户账号
     */
    private String registAcct;

    /**
     * 最后修改时间
     */
    private Date lastmodify;
    /**
     * 订单下单/生成日期
     */
    private Date modified;
    /**
     * 订单项
     */
    private List<OrderItemRespVo> order_items = new ArrayList<>();
    /**
     * 支付方式
     */
    private String pay_bn;
    /**
     * 支付状态
     */
    private Integer pay_status;
    /**
     * 已支付金额
     */
    private BigDecimal payed;
    /**
     * 支付信息
     */
    private PayInfoRespVo payinfo = new PayInfoRespVo();
    /**
     * 商品优惠描述
     */
    private List<PmtDetailRespVo> pmt_detail = new ArrayList<>();
    /**
     * 订单优惠金额
     */
    private BigDecimal pmt_order;
    /**
     * 商品优惠
     */
    private BigDecimal pmt_goods;
    /**
     * 平台优惠
     */
    private BigDecimal pmt_plateform;
    /**
     * 配送状态
     */
    private Integer ship_status;
    /**
     * 配送信息
     */
    private ShippingRespVo shipping = new ShippingRespVo();
    /**
     * 订单状态
     */
    private String status;
    /**
     * 订单流程状态
     */
    private Integer processStatus;
    /**
     * 订单总金额
     */
    private BigDecimal total_amount;
    /**
     * 门店编号
     */
    private String storeNo;
    /**
     * 分单时间
     */
    private Date pumpTime;
    /**
     * 收货人信息
     */
    private ConsigneeRespVo consigneeRespVo = new ConsigneeRespVo();
    /**
     * false: 自动分单 true : 人工分单
     */
    private Boolean isPumpSplit;
    /**
     * 配送状态：0:未发货 1：已发货 2：部分发货 3：全部发货  默认为：0
     */
    private Integer deliveryStatus;
    /**
     * 配送优先级
     */
    private Integer shippingOrder;
    /**
     * 是否改派过
     */
    private Boolean isHasDelivery;
    /**
     * 配送单版本号
     */
    private Integer deliveryVersion;
    /**
     * 拆分后的组合商品是否为空
     */
    private boolean splitGroupProductIsnull;
    /**
     * 下单渠道
     */
    private String channelsOrder;
    /**
     * 会员名
     */
    private String members_name;
    /**
     * 作息工号
     */
    private String work_routine;
    /**
     * 会员电话
     */
    private String members_phone;
    /**
     * 门店名称
     */
    private String storeName;
    /**
     * 会员账号
     */
    private String memberAccount;
    /**
     * 会员等级
     */
    private Integer memberLevel;
    /**
     * 卖家备注
     */
    private String sellerMark;
    /**
     * 送达时间
     */
    private Date sendingTime;
    /**
     * 订单进入中台时间
     */
    private Date orderSaveTime;
    /**
     * 最新改派时间
     */
    private Date lastModifyDeliveryDate;
    /**
     * 税金
     */
    private BigDecimal taxAmount;
    /**
     * 收入门店
     */
    private String incomeStoreNo;
    /**
     * 操作人
     */
    private String operatorName;
    /**
     * 操作类型
     */
    private String operatorType;
    /**
     * 物流状态
     */
    private List<OrderStatusReverseRespVo> orderStatus;
    /**
     * 配送单状态
     */
    private List<DeliveryStatusReverseRespVo> deliveryStatusDtos;
    /**
     * 退货单信息
     */
    private List<ReturnGoodsRespVo> returnGoodsDto = new ArrayList<>();
    /**
     * 行为记录
     */
    private List<BehaviorRecordRespVo> behaviorRecordDtos;

    /**
     * 报备历史
     */
    private List<OrderReportRespVo> orderReports;
    /**
     * 物流信息
     */
    private List<OrderLogisticsRespVo> orderLogisticsRespVo;
    /**
     * 中粮网商品是否缺失
     */
    private Boolean isZlProductMissing;
    /**
     * 配送单号 冗余
     */
    private String deliveryBn;
    /**
     * 退款单信息
     */
    private List<RefundOrderRespVo> refundOrders = new ArrayList<>();
    /**
     * 派单时间
     */
    private Date hasStoreTime;
    /**
     * 订单完结信息
     */
    private OrderCompletionRespVo orderCompletionDto;

    public Integer getId() {
        return id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getOrdersource() {
        return ordersource;
    }

    public void setOrdersource(String ordersource) {
        this.ordersource = ordersource;
    }

    public String getTo_node_id() {
        return to_node_id;
    }

    public void setTo_node_id(String to_node_id) {
        this.to_node_id = to_node_id;
    }

    public String getShopBn() {
        return shopBn;
    }

    public void setShopBn(String shopBn) {
        this.shopBn = shopBn;
    }

    public String getOrderType() {
        return orderType;
    }

    public void setOrderType(String orderType) {
        this.orderType = orderType;
    }

    public String getOrder_bn() {
        return order_bn;
    }

    public void setOrder_bn(String order_bn) {
        this.order_bn = order_bn;
    }

    public BigDecimal getCost_item() {
        return cost_item;
    }

    public void setCost_item(BigDecimal cost_item) {
        this.cost_item = cost_item;
    }

    public BigDecimal getCost_tax() {
        return cost_tax;
    }

    public void setCost_tax(BigDecimal cost_tax) {
        this.cost_tax = cost_tax;
    }

    public Date getCreatetime() {
        return createtime;
    }

    public void setCreatetime(Date createtime) {
        this.createtime = createtime;
    }

    public BigDecimal getCur_amount() {
        return cur_amount;
    }

    public void setCur_amount(BigDecimal cur_amount) {
        this.cur_amount = cur_amount;
    }

    public String getCurrency() {
        return currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public String getCustom_mark() {
        return custom_mark;
    }

    public void setCustom_mark(String custom_mark) {
        this.custom_mark = custom_mark;
    }

    public Integer getDiscount() {
        return discount;
    }

    public void setDiscount(Integer discount) {
        this.discount = discount;
    }

    public Boolean getIs_tax() {
        return is_tax;
    }

    public void setIs_tax(Boolean is_tax) {
        this.is_tax = is_tax;
    }

    public String getInvoiceType() {
        return invoiceType;
    }

    public void setInvoiceType(String invoiceType) {
        this.invoiceType = invoiceType;
    }

    public String getInvoiceTitle() {
        return invoiceTitle;
    }

    public void setInvoiceTitle(String invoiceTitle) {
        this.invoiceTitle = invoiceTitle;
    }

    public String getInvoiceDetails() {
        return invoiceDetails;
    }

    public void setInvoiceDetails(String invoiceDetails) {
        this.invoiceDetails = invoiceDetails;
    }

    public Boolean getPaperInvoice() {
        return isPaperInvoice;
    }

    public void setPaperInvoice(Boolean paperInvoice) {
        isPaperInvoice = paperInvoice;
    }

    public String getTaxId() {
        return taxId;
    }

    public void setTaxId(String taxId) {
        this.taxId = taxId;
    }

    public String getRegistPhoneNo() {
        return registPhoneNo;
    }

    public void setRegistPhoneNo(String registPhoneNo) {
        this.registPhoneNo = registPhoneNo;
    }

    public String getRegistAddr() {
        return registAddr;
    }

    public void setRegistAddr(String registAddr) {
        this.registAddr = registAddr;
    }

    public String getRegistBank() {
        return registBank;
    }

    public void setRegistBank(String registBank) {
        this.registBank = registBank;
    }

    public String getRegistAcct() {
        return registAcct;
    }

    public void setRegistAcct(String registAcct) {
        this.registAcct = registAcct;
    }

    public Date getLastmodify() {
        return lastmodify;
    }

    public void setLastmodify(Date lastmodify) {
        this.lastmodify = lastmodify;
    }

    public Date getModified() {
        return modified;
    }

    public void setModified(Date modified) {
        this.modified = modified;
    }

    public List<OrderItemRespVo> getOrder_items() {
        return order_items;
    }

    public void setOrder_items(List<OrderItemRespVo> order_items) {
        this.order_items = order_items;
    }

    public String getPay_bn() {
        return pay_bn;
    }

    public void setPay_bn(String pay_bn) {
        this.pay_bn = pay_bn;
    }

    public Integer getPay_status() {
        return pay_status;
    }

    public void setPay_status(Integer pay_status) {
        this.pay_status = pay_status;
    }

    public BigDecimal getPayed() {
        return payed;
    }

    public void setPayed(BigDecimal payed) {
        this.payed = payed;
    }

    public PayInfoRespVo getPayinfo() {
        return payinfo;
    }

    public void setPayinfo(PayInfoRespVo payinfo) {
        this.payinfo = payinfo;
    }

    public List<PmtDetailRespVo> getPmt_detail() {
        return pmt_detail;
    }

    public void setPmt_detail(List<PmtDetailRespVo> pmt_detail) {
        this.pmt_detail = pmt_detail;
    }

    public BigDecimal getPmt_order() {
        return pmt_order;
    }

    public void setPmt_order(BigDecimal pmt_order) {
        this.pmt_order = pmt_order;
    }

    public BigDecimal getPmt_goods() {
        return pmt_goods;
    }

    public void setPmt_goods(BigDecimal pmt_goods) {
        this.pmt_goods = pmt_goods;
    }

    public BigDecimal getPmt_plateform() {
        return pmt_plateform;
    }

    public void setPmt_plateform(BigDecimal pmt_plateform) {
        this.pmt_plateform = pmt_plateform;
    }

    public Integer getShip_status() {
        return ship_status;
    }

    public void setShip_status(Integer ship_status) {
        this.ship_status = ship_status;
    }

    public ShippingRespVo getShipping() {
        return shipping;
    }

    public void setShipping(ShippingRespVo shipping) {
        this.shipping = shipping;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public Integer getProcessStatus() {
        return processStatus;
    }

    public void setProcessStatus(Integer processStatus) {
        this.processStatus = processStatus;
    }

    public BigDecimal getTotal_amount() {
        return total_amount;
    }

    public void setTotal_amount(BigDecimal total_amount) {
        this.total_amount = total_amount;
    }

    public String getStoreNo() {
        return storeNo;
    }

    public void setStoreNo(String storeNo) {
        this.storeNo = storeNo;
    }

    public Date getPumpTime() {
        return pumpTime;
    }

    public void setPumpTime(Date pumpTime) {
        this.pumpTime = pumpTime;
    }

    public ConsigneeRespVo getConsigneeRespVo() {
        return consigneeRespVo;
    }

    public void setConsigneeRespVo(ConsigneeRespVo consigneeRespVo) {
        this.consigneeRespVo = consigneeRespVo;
    }

    public Boolean getPumpSplit() {
        return isPumpSplit;
    }

    public void setPumpSplit(Boolean pumpSplit) {
        isPumpSplit = pumpSplit;
    }

    public Integer getDeliveryStatus() {
        return deliveryStatus;
    }

    public void setDeliveryStatus(Integer deliveryStatus) {
        this.deliveryStatus = deliveryStatus;
    }

    public Integer getShippingOrder() {
        return shippingOrder;
    }

    public void setShippingOrder(Integer shippingOrder) {
        this.shippingOrder = shippingOrder;
    }

    public Boolean getHasDelivery() {
        return isHasDelivery;
    }

    public void setHasDelivery(Boolean hasDelivery) {
        isHasDelivery = hasDelivery;
    }

    public Integer getDeliveryVersion() {
        return deliveryVersion;
    }

    public void setDeliveryVersion(Integer deliveryVersion) {
        this.deliveryVersion = deliveryVersion;
    }

    public boolean isSplitGroupProductIsnull() {
        return splitGroupProductIsnull;
    }

    public void setSplitGroupProductIsnull(boolean splitGroupProductIsnull) {
        this.splitGroupProductIsnull = splitGroupProductIsnull;
    }

    public String getChannelsOrder() {
        return channelsOrder;
    }

    public void setChannelsOrder(String channelsOrder) {
        this.channelsOrder = channelsOrder;
    }

    public String getMembers_name() {
        return members_name;
    }

    public void setMembers_name(String members_name) {
        this.members_name = members_name;
    }

    public String getWork_routine() {
        return work_routine;
    }

    public void setWork_routine(String work_routine) {
        this.work_routine = work_routine;
    }

    public String getMembers_phone() {
        return members_phone;
    }

    public void setMembers_phone(String members_phone) {
        this.members_phone = members_phone;
    }

    public String getStoreName() {
        return storeName;
    }

    public void setStoreName(String storeName) {
        this.storeName = storeName;
    }

    public String getMemberAccount() {
        return memberAccount;
    }

    public void setMemberAccount(String memberAccount) {
        this.memberAccount = memberAccount;
    }

    public Integer getMemberLevel() {
        return memberLevel;
    }

    public void setMemberLevel(Integer memberLevel) {
        this.memberLevel = memberLevel;
    }

    public String getSellerMark() {
        return sellerMark;
    }

    public void setSellerMark(String sellerMark) {
        this.sellerMark = sellerMark;
    }

    public Date getSendingTime() {
        return sendingTime;
    }

    public void setSendingTime(Date sendingTime) {
        this.sendingTime = sendingTime;
    }

    public Date getOrderSaveTime() {
        return orderSaveTime;
    }

    public void setOrderSaveTime(Date orderSaveTime) {
        this.orderSaveTime = orderSaveTime;
    }

    public Date getLastModifyDeliveryDate() {
        return lastModifyDeliveryDate;
    }

    public void setLastModifyDeliveryDate(Date lastModifyDeliveryDate) {
        this.lastModifyDeliveryDate = lastModifyDeliveryDate;
    }

    public BigDecimal getTaxAmount() {
        return taxAmount;
    }

    public void setTaxAmount(BigDecimal taxAmount) {
        this.taxAmount = taxAmount;
    }

    public String getIncomeStoreNo() {
        return incomeStoreNo;
    }

    public void setIncomeStoreNo(String incomeStoreNo) {
        this.incomeStoreNo = incomeStoreNo;
    }

    public String getOperatorName() {
        return operatorName;
    }

    public void setOperatorName(String operatorName) {
        this.operatorName = operatorName;
    }

    public String getOperatorType() {
        return operatorType;
    }

    public void setOperatorType(String operatorType) {
        this.operatorType = operatorType;
    }

    public List<OrderStatusReverseRespVo> getOrderStatus() {
        return orderStatus;
    }

    public void setOrderStatus(List<OrderStatusReverseRespVo> orderStatus) {
        this.orderStatus = orderStatus;
    }

    public List<DeliveryStatusReverseRespVo> getDeliveryStatusDtos() {
        return deliveryStatusDtos;
    }

    public void setDeliveryStatusDtos(List<DeliveryStatusReverseRespVo> deliveryStatusDtos) {
        this.deliveryStatusDtos = deliveryStatusDtos;
    }

    public List<ReturnGoodsRespVo> getReturnGoodsDto() {
        return returnGoodsDto;
    }

    public void setReturnGoodsDto(List<ReturnGoodsRespVo> returnGoodsDto) {
        this.returnGoodsDto = returnGoodsDto;
    }

    public List<BehaviorRecordRespVo> getBehaviorRecordDtos() {
        return behaviorRecordDtos;
    }

    public void setBehaviorRecordDtos(List<BehaviorRecordRespVo> behaviorRecordDtos) {
        this.behaviorRecordDtos = behaviorRecordDtos;
    }

    public List<OrderReportRespVo> getOrderReports() {
        return orderReports;
    }

    public void setOrderReports(List<OrderReportRespVo> orderReports) {
        this.orderReports = orderReports;
    }

    public List<OrderLogisticsRespVo> getOrderLogisticsRespVo() {
        return orderLogisticsRespVo;
    }

    public void setOrderLogisticsRespVo(List<OrderLogisticsRespVo> orderLogisticsRespVo) {
        this.orderLogisticsRespVo = orderLogisticsRespVo;
    }

    public Boolean getZlProductMissing() {
        return isZlProductMissing;
    }

    public void setZlProductMissing(Boolean zlProductMissing) {
        isZlProductMissing = zlProductMissing;
    }

    public String getDeliveryBn() {
        return deliveryBn;
    }

    public void setDeliveryBn(String deliveryBn) {
        this.deliveryBn = deliveryBn;
    }

    public List<RefundOrderRespVo> getRefundOrders() {
        return refundOrders;
    }

    public void setRefundOrders(List<RefundOrderRespVo> refundOrders) {
        this.refundOrders = refundOrders;
    }

    public Date getHasStoreTime() {
        return hasStoreTime;
    }

    public void setHasStoreTime(Date hasStoreTime) {
        this.hasStoreTime = hasStoreTime;
    }

    public OrderCompletionRespVo getOrderCompletionDto() {
        return orderCompletionDto;
    }

    public void setOrderCompletionDto(OrderCompletionRespVo orderCompletionDto) {
        this.orderCompletionDto = orderCompletionDto;
    }
}
