package com.biz.interfacedocker.wallet.rebate.dto;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 描述:
 * 电子钱包返利详情DTO
 *
 * @author Vincent
 * @create 2017-11-22 16:50rebate_detail
 * @project_name interfaceDocker
 */
public class WalletRebateOrderDTO implements Serializable{
	private static final long serialVersionUID = 5437442776080666191L;

	/**
	 * 订单编码
	 */
	private String orderNo;

	/**
	 * 返利总金额
	 */
	private Integer rebateTotalAmount;

	/**
	 * 0=处理失败 1=无需处理(未存在返利) 2=已经处理返利
	 */
	private Integer status;

	/**
	 * 消息  处理失败 无需处理(未存在返利) 已经处理返利
	 */
	private String message;

	/**
	 * 返利时间（充值到账户的时间）
	 */
	private Date rebateTime;

	/**
	 * 系统当前时间
	 */
	private Date currentTime;

	/**
	 * 返利商品明细
	 */
	private List<WalletRebateProductDTO> walletRebateProductDTOS;


	public String getOrderNo() {
		return orderNo;
	}

	public void setOrderNo(String orderNo) {
		this.orderNo = orderNo;
	}

	public Integer getRebateTotalAmount() {
		return rebateTotalAmount;
	}

	public void setRebateTotalAmount(Integer rebateTotalAmount) {
		this.rebateTotalAmount = rebateTotalAmount;
	}

	public Integer getStatus() {
		return status;
	}

	public void setStatus(Integer status) {
		this.status = status;
	}

	public String getMessage() {
		return message;
	}

	public void setMessage(String message) {
		this.message = message;
	}

	public Date getRebateTime() {
		return rebateTime;
	}

	public void setRebateTime(Date rebateTime) {
		this.rebateTime = rebateTime;
	}

	public Date getCurrentTime() {
		return currentTime;
	}

	public void setCurrentTime(Date currentTime) {
		this.currentTime = currentTime;
	}

	public List<WalletRebateProductDTO> getWalletRebateProductDTOS() {
		return walletRebateProductDTOS;
	}

	public void setWalletRebateProductDTOS(List<WalletRebateProductDTO> walletRebateProductDTOS) {
		this.walletRebateProductDTOS = walletRebateProductDTOS;
	}

	@Override
	public String toString() {
		return ToStringBuilder.reflectionToString(this);
	}
}
