package com.biz.interfacedocker.winecard.service;
/**
 * WineCardAutoExpiredApiService
 * Description:
 * @author: weitongyan
 * @date: 27/Dec/2017 14:36
 */

public interface WineCardAutoExpiredApiService {

    /**
     * 定时任务自动更新支付单过期状态
     * 目的：保证超过15分钟的支付订单被设置为已超时（最坏情况下19.9分钟后被设置）
     * 定时任务每5分钟跑一次，检查过去30分钟-15分钟未支付的支付单
     */
    void autoExpirePaymentOrder();

    /**
     * 定时任务自动更新过期卡状态
     * 定时任务每天跑一次，检查已过期的状态还为正常使用的储值卡与用户储值卡
     */
    void autoUpdateExpiredCardStatus();
    
}
