/**
 * @Description: 
 * @ClassName: com.biz.dbDocker.service.InventoryDbService
 * @author: Omar(OmarZhang)
 * @date: 2016年3月7日 上午10:47:16 
 */
package com.biz.interfacedocker.barcode.service;

import com.biz.interfacedocker.barcode.vo.PdaVersionVo;
import com.biz.interfacedocker.barcode.vo.req.PdaModifyBcCodeReqVo;
import com.biz.interfacedocker.common.JsonResult;


/**
 * PDA相关接口
 * @date: 2016年3月7日 上午10:47:16 
 *
 */
public interface PdaApiService {
	
	/**
	 * 查询PDA最新版本查询
	 * @return
	 */
	public PdaVersionVo getLastPdaVersion();
	
	/**
	 * 新版本查询PDA最新版本查询
	 * version 1 门店PDA版本  0  供应商PDA版本
	 * @return
	 */
	public JsonResult getPdaVersion(String version);
	
	/***
	 * PDA-门店二维码的查修改
	 * PDA 传 :门店编号、商品编号、二维码
	 */
	@SuppressWarnings("rawtypes")
	public JsonResult pdaDeBugBcInfo(PdaModifyBcCodeReqVo reqVo );
	
	
}
