/**
 * @Description: 
 * @ClassName: com.biz.centerdocker.common.JsonResult
 * @author: Omar(OmarZhang)
 * @date: 2016年1月13日 下午12:28:05 
 */
package com.biz.interfacedocker.common;

import java.io.Serializable;

import com.biz.interfacedocker.common.type.HttpResultStatus;

/**
 * 自定义返回结果集
 * 
 * @Description:
 * @ClassName: com.biz.centerdocker.common.JsonResult
 * @author: Omar(OmarZhang)
 * @param <T>
 * @date: 2016年1月13日 下午12:28:05
 *
 */
public class JsonResult<T> extends Result implements Serializable{

	/**
	 * @Fields serialVersionUID : TODO
	 */
	private static final long serialVersionUID = 1L;

	/** 返回的自定义封装的结果集 */
	private T respBody;

	/** 返回的状态 */
	private HttpResultStatus status;

	/** 返回 */
	private String subMsg;

	public JsonResult(int code, String code_msg) {
		super(code, code_msg);
		// TODO Auto-generated constructor stub
	}

	public JsonResult(int code) {
		super(code);
		// TODO Auto-generated constructor stub
	}
	public JsonResult() {
		super();
	}
	public JsonResult(HttpResultStatus status) {
		super(status.statusCode(), status.describe());
		this.status = status;
	}

	public JsonResult(HttpResultStatus status, String subMsg) {
		super(status.statusCode(), status.describe());
		this.status = status;
		this.subMsg = subMsg;
	}

	public JsonResult(HttpResultStatus status, T data) {
		super(status.statusCode(), status.describe());
		this.status = status;
		this.respBody = data;
	}

	public JsonResult(HttpResultStatus status, String subMsg, T data) {
		super(status.statusCode(), status.describe());
		this.status = status;
		this.subMsg = subMsg;
		this.respBody = data;
	}

	public T getRespBody() {
		return respBody;
	}

	public void setRespBody(T respBody) {
		this.respBody = respBody;
	}

	public HttpResultStatus getStatus() {
		return status;
	}

	public void setStatus(HttpResultStatus status) {
		this.status = status;
	}

	public String getSubMsg() {
		return subMsg;
	}

	public void setSubMsg(String subMsg) {
		this.subMsg = subMsg;
	}

}
