package com.biz.interfacedocker.common.type;

/**
 * 
 * @author Pan
 *
 * @date 2016年6月14日 下午3:08:25
 * @type HttpResultType
 */
public enum HttpResultStatus {

	/**
	 * 处理成功
	 */
	EXECUTE_SUCCESS(0001, "处理成功"), // </br>

	/**
	 * 处理失败
	 */
	EXECUTE_FAIL(4001, "处理失败"), // </br>

	/**
	 * 系统异常
	 */
	SYSTEM_ERROR(4002, "系统异常"), // </br>

	/**
	 * 认真信息为空
	 */
	IDENTIFICATION_EMPTY(5001, "认证信息为空"), // </br>

	/**
	 * 认证信息不匹配
	 */
	IDENTIFICATION_MISMATCHING(5002, "认证信息不匹配"), // </br>

	/**
	 * 认证失败
	 */
	IDENTIFICATION_FAIL(5999, "认证失败"), // </br>

	/**
	 * 参数异常
	 */
	PARAMETER_ERROR(6001, "参数异常"),
	
	USER_NOT_EXIST(1000,"用户信息不存在"),
	
	NOT_VALID_ARREINFO(1001,"区域信息不合法");

	/**
	 * 状态码
	 */
	private int statusCode;

	/**
	 * 状态码描述
	 */
	private String describe;

	HttpResultStatus(int statusCode, String describe) {
		this.statusCode = statusCode;
		this.describe = describe;
	}

	@Override
	public String toString() {
		return "status:" + this.name() + "\tstatusCode:" + statusCode + "\t\tmsg:" + describe;
	}

	public int statusCode() {
		return statusCode;
	}

	public String describe() {
		return describe;
	}

}
