package com.biz.interfacedocker.logistics.vo;

import com.biz.interfacedocker.logistics.enums.LogisticsStatus;

import java.io.Serializable;
import java.sql.Timestamp;

public class SearchLogisticsItemRespVo implements Serializable, Comparable<SearchLogisticsItemRespVo> {
    private static final long serialVersionUID = -512693873769166439L;
    //必选 物流详情描述
    private String statusDescDetail;
    //物流状态
    private LogisticsStatus status = LogisticsStatus.OUTBOUND;
    //必选 物流详情时间
    private Timestamp pubTime;
    //可选 当前城市
    private String city;
    //操作人
    private String operator;

    public String getStatusDescDetail() {
        return statusDescDetail;
    }

    public void setStatusDescDetail(String statusDescDetail) {
        this.statusDescDetail = statusDescDetail;
    }

    public LogisticsStatus getStatus() {
        return status;
    }

    public void setStatus(LogisticsStatus status) {
        this.status = status;
    }

    public Timestamp getPubTime() {
        return pubTime;
    }

    public void setPubTime(Timestamp pubTime) {
        this.pubTime = pubTime;
    }

    public String getCity() {
        return city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getOperator() {
        return operator;
    }

    public void setOperator(String operator) {
        this.operator = operator;
    }

    @Override
    public int compareTo(SearchLogisticsItemRespVo o) {
        return this.getPubTime() != null && o.getPubTime() != null ? this.getPubTime().compareTo(o.getPubTime()) : 0;
    }
}
