package com.biz.interfacedocker.mdbWeb.service;

import java.util.List;

import com.biz.interfacedocker.mdbWeb.vo.WarehouseWebVo;
import com.biz.interfacedocker.mdbWeb.vo.common.Pager;

public interface WarehouseWebApiService {

	/**
	 * 返回所有仓库主数据
	 */
	public List<WarehouseWebVo> findAll();

	/**
	 * 根据查询条件分页返回仓库主数据信息
	 * 
	 * @Title: findWarehouseByParams
	 * @param BUKRS
	 *            公司代码
	 * @param BUTXT
	 *            公司名称
	 * @param WERKS
	 *            仓库编号
	 * @param NAME1
	 *            仓库描述
	 * @param KUNNR
	 *            仓库的客户号
	 * @param LIFNR
	 *            仓库的供应商号
	 * @param REGIO
	 *            省编码
	 * @param CITYC
	 *            市编码
	 * @param TRANSPZONE
	 *            区编码
	 * @param pageNum
	 *            显示第几页
	 * @param pageSize
	 *            每页显示条数
	 * @param request
	 * @return
	 * @author: zhouyannian
	 * @date: 2016年7月21日 上午10:29:36
	 */
	public Pager<WarehouseWebVo> findWarehouseByParams(String BUKRS, String BUTXT, String WERKS, String NAME1, String KUNNR,
			String LIFNR, String REGIO, String CITYC, String TRANSPZONE, Integer pageNum, Integer pageSize);

	/**
	 * 分页返回所有品牌公司
	 * 
	 * @Title: findAllBrandCompanyPage
	 * @param pageNum
	 *            显示第几页
	 * @param pageSize
	 *            每页显示条数
	 * @return
	 * @author: zhouyannian
	 * @date: 2016年8月26日 上午10:29:36
	 */
	public Pager<WarehouseWebVo> findAllBrandCompanyPage(Integer pageNum, Integer pageSize);

	/**
	 * 分页返回所有省公司
	 * 
	 * @Title: findAllProvinceCompanyPage
	 * @param pageNum
	 *            显示第几页
	 * @param pageSize
	 *            每页显示条数
	 * @return
	 * @author: zhouyannian
	 * @date: 2016年8月26日 上午10:29:36
	 */
	public Pager<WarehouseWebVo> findAllProvinceCompanyPage(Integer pageNum, Integer pageSize);
	
	/**
	 * 根据更新时间查询仓库
	 * 
	 * @param updatetimeLt
	 *            开始时间
     * @param updatetimeGt
	 *            结束时间
	 * @return
	 * @author: zhouyannian
	 * @date: 2016年8月26日 上午10:29:36
	 */
	public List<WarehouseWebVo> findWarehouseByUpdatetime(String updatetimeLt,String updatetimeGt);
	
	/**
	 * 返回所有省仓
	 * 
	 * @return
	 * @author: zhouyannian
	 * @date: 2016年10月08日 下午04:29:36
	 */
	public List<WarehouseWebVo> findAllProvinceWarehouse();
	
	/**
	 * 根据省仓编码查询省仓
	 * 
	 * @param warehouseId
	 *            省仓编码
	 * @return
	 * @author: zhouyannian
	 * @date: 2016年10月08日 下午04:29:36
	 */
	public List<WarehouseWebVo> findProvinceWarehouseById(String warehouseId);
	
	/**
	 * 根据省公司编码和名称分页返回所有的省公司
	 * 
	 * @param companyId
	 *            省公司编码
     * @param companyName
	 *            省公司名称
	 * @param pageNum
	 *            显示第几页
	 * @param pageSize
	 *            每页显示条数
	 * @return
	 * @author: zhouyannian
	 * @date: 2016年11月17日 上午10:29:36
	 */
	public Pager<WarehouseWebVo> findProvinceCompanyByIdAndName(String companyId, String companyName,Integer pageNum, Integer pageSize);

	
}
